# -*- coding: utf-8 -*-
"""Поллер для сессий и примитивов синхронизации."""


class ICQPoll(object):
    """
    Поллер, который проверяет находящиеся в нём объекты на готовность
    отдавать данные. В данный момент работает только с
    :class:`сессиями <.ICQSession>` и :class:`трубами <.ICQPipe>`.
    """
    def __init__(self, slave):
        self.__slave = slave

    def add(self, obj):
        """
        Добавить объект в поллер.

        :param Selectable obj: объект сессии или трубы
        """
        self.__slave.add(obj)

    def remove(self, obj):
        """
        Удалить объект из поллера

        :param Selectable obj: объект сессии или трубы, находящихся в поллере
        """
        self.__slave.remove(obj)

    def poll(self, timeout=None):
        """
        Опросить объекты на наличие данных. Управление возвращается, как только
        появляются объекты, доступные для чтения, или по истечении таймаута.

        :param float timeout: максимально время в секундах на опрос объектов, или
                              None, для опроса без ограничений, пока не появится
                              хоть кто-нибудь
        :rtype: list
        :return: список объектов, готовых для чтения
        """
        return self.__slave.poll(timeout)
