# -*- coding: utf-8 -*-


class IRemoteObject(object):
    """
    Базовый класс задачи.

    Задача совершенно не обязана быть от него унаследована, но если хочется иметь
    в своей IDE подсказки о доступных для модификации параметрах, то почему бы и
    нет.

    .. NOTE::

        Многие свойства этого класса остались только с целью сохранения обратной
        совместимости и больше не используются. Они специально не документированы.
    """

    def __call__(self):
        """Метод, который будет исполнен на удалённой стороне"""

    def __iter__(self):
        """
        Больше не используется
        """

    def __str__(self):
        """Строковое представление задачи"""
        return super(IRemoteObject, self).__str__()

    @property
    def acUser(self):
        """
        Пользователь, поставивший задачу.
        Никакого влияния на выполнение задачи это свойство не оказывает,
        но используется для статистики. По умолчанию используется системный
        пользователь.
        """
        return None

    @property
    def osUser(self):
        """
        Пользователь, от имени которого требуется выполнить задачу.
        Если не задан, то задача будет выполнена от имени текущего пользователя

        .. NOTE::
            Если задача выполняется под специально указанным пользователем, это
            требует авторизацию от имени этого пользователя на сервере.
        """
        import os
        return os.environ.get('CQUEUE_USER', None)

    @property
    def forwardSshAgent(self):
        """
        Опция, указывающая на необходимость предоставления SSH-агента на
        удалённой стороне.

        Если опция включена, то на удалённой стороне будет создан специальный
        unix-сокет, пробрасывающий все запросы ключей на сторону пользователя,
        а в переменных окружения задачи будет создана переменная ``SSH_AUTH_SOCK``,
        которую смогут использовать ssh и другие программы, поддерживающие SSH-агент.
        """
        return False

    @property
    def queueDescriptor(self):
        # Не используется
        return None

    @property
    def processPriority(self):
        # Не используется
        return None

    @property
    def networkPriority(self):
        # Не используется
        return None

    @property
    def connectionTimeouts(self):
        # Не используется
        return [0.2, 0.3, 0.5, 0.5, 0.5]

    @property
    def discoverTimeout(self):
        # Не используется
        return None

    @property
    def orphanTimeout(self):
        # Не используется
        return 5 * 60

    @property
    def sessionTimeout(self):
        """
        Таймаут жизни сессии.
        Если установлен, то по истечении данного времени (в секундах) все узлы,
        которые на данный момент ещё не закончили присылать результаты, будут отмечены
        как отвалившиеся по таймауту.

        По умолчанию значение отсутствует, то есть клиент будет ожидать результатов от
        задачи бесконечное количество времени.
        """
        return None

    @property
    def marshaledModules(self):
        """
        Список модулей для пересылки на удалённую сторону.
        Если не установлен, то пересылаются все модули, которые обнаружены в :data:`sys.modules`,
        в противном случае будут переданы только запрошенные модули (это помогает экономить
        время и трафик).
        """
        return None

    @property
    def resendPeriod(self):
        # Не используется
        return 0

    @property
    def reconnectOnErrors(self):
        # Не используется
        return False

    @property
    def obj(self):
        return self
