#!/bin/sh

PROGRAM=$0

show_help() {
    echo "Usage: $PROGRAM [-t] [-s]"
    echo "   -t      push archive to testing"
    echo "   -s      push archive to stable"
}
check_token() {
    if [ -z "$DAAS_OAUTH" ]
    then
        echo 'Environment variable DAAS_OAUTH is not set.'
        echo 'Obtain token here: https://oauth.yandex-team.ru/authorize?response_type=token&client_id=38ded400390240768d721ee805decae4'
        echo 'More info here: https://st.yandex-team.ru/DOC-4604#5d9729c0701665001c1a35c8'
        exit 1
    fi
}

TO_TESTING=
TO_STABLE=
OPTIND=1
while getopts "h?ts" opt
do
    case "$opt" in
        h|\?)
            show_help
            exit 0
            ;;
        t)
            TO_TESTING=1
            check_token
            ;;
        s)
            TO_STABLE=1
            check_token
            ;;
    esac
done

unset SPHINXBUILD
PYTHONPATH=$(dirname "$0")/../..:
export PYTHONPATH

if [ ! -d .docsvenv ]; then
    python -m virtualenv .docsvenv || (
        echo "No virtualenv in your system."
        # shellcheck disable=SC2016
        echo 'Use `sudo apt install python-virtualenv` in Ubuntu or your package manager in other OS'
    )
fi
. .docsvenv/bin/activate

 pip install ply py sphinx==1.8.5 sphinx-autorun pyyaml msgpack psutil fastcache
 pip install anytree -e 'svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia/locdoc/doc_tools/sphinx/sphinx_doccenter#egg=sphinx_doccenter'
.docsvenv/bin/python build.py

rm -rf build/.doctrees build/.buildinfo
tar czf docs.tar.gz -C build .

if [ -n "$TO_TESTING" ]
then
    if curl -F archive=@docs.tar.gz -H "Authorization: OAuth $DAAS_OAUTH" 'http://internal.daas-backend-int.locdoc-test.yandex.net/v1/projects/1872/deploy'
    then
        echo "Uploaded successfully, to test open https://doc.test.yandex-team.ru/Search/skynet-api/"
    fi
    
fi

if [ -n "$TO_STABLE" ]
then
    if curl -F archive=@docs.tar.gz -H "Authorization: OAuth $DAAS_OAUTH" 'http://internal.daas-backend-int.yandex.net/v1/projects/1178/deploy'
    then
        echo "Uploaded successfully, to test open https://doc.yandex-team.ru/Search/skynet-api/"
    fi
fi

