#!/skynet/python/bin/python
from __future__ import print_function

import sys
import os
import subprocess

from argparse import ArgumentParser, Namespace


parser = ArgumentParser()
parser.add_argument('--open', '-o', action='store_true', default=False)
parser.add_argument('--debug', '-d', action='store_true', default=False)
parser.add_argument('--build_dir', '-b', dest='buildDir', default=None, help='Path to created documentation snapshot')
parser.add_argument('--mode', '-m', dest='mode', default='html', help='Sphinx documentation mode')
options = Namespace()


def main():
    if not os.path.isdir(options.buildDir):
        os.makedirs(options.buildDir)

    sphinxBuild = os.environ.get('SPHINXBUILD', 'sphinx-build')
    shellCall('{sphinxBuild} -ab {mode} -d {buildDir}/.doctrees -c {projectDir}/docs/ {projectDir} {buildDir}'.format(
        sphinxBuild=sphinxBuild,
        mode=options.mode,
        buildDir=options.buildDir,
        projectDir=os.path.dirname(os.path.dirname(os.path.abspath(__file__))),
    ))

    if options.open:
        import webbrowser
        webbrowser.open(os.path.join(options.buildDir, 'index.html'))


def shellCall(cmd, setPythonPath=True):
    print('Calling `{0}`'.format(cmd))

    pathSep = ':' if os.name == 'posix' else ';'

    if setPythonPath:
        env = dict(os.environ)
        path = '{0}{1}{2}'.format(
            os.path.join(os.path.dirname(os.path.dirname(os.path.dirname(os.path.abspath(__file__))))),
            pathSep,
            env.get('PYTHONPATH', '')
        )
        env['PYTHONPATH'] = path
    else:
        env = None

    stdout = subprocess.PIPE
    stderr = subprocess.PIPE

    process = subprocess.Popen(cmd, shell=True, stdout=stdout, stderr=stderr, env=env)
    outs = process.communicate()

    print(outs[0])

    if process.returncode:
        print(outs[1], file=sys.stderr)
        raise SystemExit(1)

    print(outs[1], file=sys.stderr)

    return outs[0]

if __name__ == '__main__':
    options = parser.parse_args()

    if options.buildDir is None:
        options.buildDir = os.path.join(os.path.dirname(os.path.abspath(__file__)), 'build')

    main()
