# -*- coding: utf-8 -*-
#
# IPI.Manager Developer Docs documentation build configuration file, created by
# sphinx-quickstart on Fri Apr  9 16:47:05 2010.
#
# This file is execfile()d with the current directory set to its containing dir.
#
# Note that not all possible configuration values are present in this
# autogenerated file.
#
# All configuration values have a default; values that are commented out
# serve to show the default.

import sys
import os

# If extensions (or modules to document with autodoc) are in another directory,
# add these directories to sys.path here. If the directory is relative to the
# documentation root, use os.path.abspath to make it absolute, like shown here.
sys.path.append(os.path.abspath('./_exts'))

# -- General configuration -----------------------------------------------------

# Add any Sphinx extension module names here, as strings. They can be extensions
# coming with Sphinx (named 'sphinx.ext.*') or your custom ones.
extensions = [
    'sphinx.ext.autodoc',
    'sphinx.ext.autosummary',
    'sphinx.ext.intersphinx',
    'sphinx.ext.inheritance_diagram',
    'sphinx.ext.coverage',
    'sphinx.ext.imgmath',
    'sphinx.ext.ifconfig',
    'sphinx.ext.todo',
    'sphinx.ext.viewcode',
    'sphinx_autorun',
    # 'rst2pdf.pdfbuilder',
    'sphinx_doccenter',  # to build for Yandex DaaS
]

# Add any paths that contain templates here, relative to this directory.
templates_path = ['_templates']

# The suffix of source filenames.
source_suffix = '.rst'

# The encoding of source files.
source_encoding = 'utf-8'

# The master toctree document.
master_doc = 'index'

# General information about the project.
project = u'Skynet API Docs'
copyright = u'2011-2019, Yandex'

# The version info for the project you're documenting, acts as replacement for
# |version| and |release|, also used in various other places throughout the
# built documents.
#
# The short X.Y version.
version = '0.0.9'
# The full version, including alpha/beta/rc tags.
release = '0.0.9'

# The language for content autogenerated by Sphinx. Refer to documentation
# for a list of supported languages.
language = 'ru'

# There are two options for replacing |today|: either, you set today to some
# non-false value, then it is used:
# today = ''
# Else, today_fmt is used as the format for a strftime call.
# today_fmt = '%B %d, %Y'

# List of documents that shouldn't be included in the build.
# unused_docs = []

# List of directories, relative to source directory, that shouldn't be searched
# for source files.
exclude_patterns = ['docs/**']

# The reST default role (used for this markup: `text`) to use for all documents.
# default_role = None

# If true, '()' will be appended to :func: etc. cross-reference text.
add_function_parentheses = True

# If true, the current module name will be prepended to all description
# unit titles (such as .. function::).
add_module_names = True

# If true, sectionauthor and moduleauthor directives will be shown in the
# output. They are ignored by default.
show_authors = True

# The name of the Pygments (syntax highlighting) style to use.
# pygments_style = 'fruity'
pygments_style = 'pastie'
# A list of ignored prefixes for module index sorting.
# modindex_common_prefix = ['.ipi']


# -- Options for HTML output ---------------------------------------------------

# The theme to use for HTML and HTML Help pages.  Major themes that come with
# Sphinx are currently 'default' and 'sphinxdoc'.
# html_theme = 'mocksoul'
# html_theme = 'default'
html_theme = 'sphinx_doccenter'
# html_theme = 'pyramid'

# Theme options are theme-specific and customize the look and feel of a theme
# further.  For a list of options available for each theme, see the
# documentation.
# html_theme_options = {'collapsiblesidebar': True}
# html_theme_options = {'collapsiblesidebar': True, 'sidebarwidth': 300, 'externalrefs': True}  # for default theme
# html_theme_options = {'sidebarwidth': 300}  # for pyramid theme

# Add any paths that contain custom themes here, relative to this directory.
html_theme_path = ['_themes']

# The name for this set of Sphinx documents.  If None, it defaults to
# "<project> v<release> documentation".
html_title = u"Руководство Skynet API"

# A shorter title for the navigation bar.  Default is the same as html_title.
# html_short_title = None

# The name of an image filxe (relative to this directory) to place at the top
# of the sidebar.
# html_logo = None

# The name of an image file (within the static path) to use as favicon of the
# docs.  This file should be a Windows icon file (.ico) being 16x16 or 32x32
# pixels large.
# html_favicon = None

# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
html_static_path = ['_static']

# If not '', a 'Last updated on:' timestamp is inserted at every page bottom,
# using the given strftime format.
html_last_updated_fmt = '%d %B %Y, %H:%M:%S'

# If true, SmartyPants will be used to convert quotes and dashes to
# typographically correct entities.
html_use_smartypants = True

# Custom sidebar templates, maps document names to template names.
html_sidebars = {
    '**': ['maintoc.html', 'doctoc.html', 'relations.html', 'sourcelink.html', 'searchbox.html']
}

# Additional templates that should be rendered to pages, maps page names to
# template names.
# html_additional_pages = {}

# If false, no module index is generated.
html_use_modindex = True

# If false, no index is generated.
html_use_index = True

# If true, the index is split into individual pages for each letter.
# html_split_index = False

# If true, links to the reST sources are added to the pages.
html_show_sourcelink = True

# If true, an OpenSearch description file will be output, and all pages will
# contain a <link> tag referring to it.  The value of this option must be the
# base URL from which the finished HTML is served.
# html_use_opensearch = ''

# If nonempty, this is the file name suffix for HTML files (e.g. ".xhtml").
# html_file_suffix = ''

# Output file base name for HTML help builder.
htmlhelp_basename = 'SkynetAPIDocs'


# -- Options for LaTeX output --------------------------------------------------

# Grouping the document tree into LaTeX files. List of tuples
# (source start file, target name, title, author, documentclass [howto/manual]).
latex_documents = [
    ('index', project.replace(' ', '') + '.tex', '%s %s Documentation' % (project, version), 'Vadim Fint', 'manual')
]

# The name of an image file (relative to this directory) to place at the top of
# the title page.
latex_logo = None

# For "manual" documents, if this is true, then toplevel headings are parts,
# not chapters.
latex_use_parts = False

# Documents to append as an appendix to all manuals.
# latex_appendices = []

# If false, no module index is generated.
latex_use_modindex = True

latex_elements = {
    'papersize': 'a4paper',
    'fontpkg': '',
    'fncychap': '\\usepackage[Sonny]{fncychap}',
    # 'fncychap': ''
}

# Example configuration for intersphinx: refer to the Python standard library.
intersphinx_mapping = {'python': ('http://docs.python.org/2', None)}

todo_include_todos = True
# autosummary_generate = ['sources/index']
autodoc_member_order = 'bysource'
autodoc_default_flags = ['members', 'undoc-members', 'show-inheritance']

pdf_documents = [('index', project, "%s %s Documentation" % (project, version), 'Georg Brandl')]
pdf_stylesheets = ['sphinx', 'kerning', 'a4', 'eightpoint', 'fruity']
# pdf_fit_mode='shrink'
pdf_break_level = 1
pdf_use_index = True
pdf_use_modindex = True
pdf_use_coverpage = True
pdf_verbosity = 0
pdf_language = 'ru'
pdf_splittables = True
pdf_extensions = ['vectorpdf', 'dotted_toc']

autorun_languages = {}
autorun_languages['pycon'] = 'python -'
autorun_languages['pycon_prefix_chars'] = 0
autorun_languages['sh'] = 'sh -s'

# DaaS settings
product_id = 'skynet'
product_name = u'Skynet'
doc_id = 'skynet_api'
doc_name = u'Skynet'
site_url = 'https://doc.yandex-team.ru/skynet-api'
