class DcInfoNotFoundError(Exception):
    pass


class HivemindHttpError(Exception):
    def __init__(self, code, reason):
        self.code = code
        self.reason = reason
        Exception.__init__(self, "hivemind api http error: {0} {1}".format(code, reason))


class DcInfo(object):
    HOST_PORT = 'hivemind.yandex-team.ru'
    DC_URL = 'http://{0}/v1/dcs/{1}/hosts?fmt=msgpack'
    LINE_URL = 'http://{0}/v1/lines/{1}/hosts?fmt=msgpack'
    HOST_URL = 'http://{0}/v1/hosts/{1}/dc?fmt=msgpack'

    DEFAULT_TIMEOUTS = [0.1, 0.5, 1, 5]

    def __init__(self, timeouts=None):
        pass

    def _do_requests(self, request, not_found_error):
        raise not_found_error

    def dc_hosts(self, dc_name):
        raise DcInfoNotFoundError("datacenter '{0}' is not known to hivemind".format(dc_name))

    def line_hosts(self, line_name):
        raise DcInfoNotFoundError("line '{0}' is not known to hivemind".format(line_name))

    def host_dc(self, host):
        raise DcInfoNotFoundError("host '{0}' is not known to hivemind".format(host))
