from kernel.util.pytest import TestBrick
from kernel.util.functional import memoized


class FakeLogger(TestBrick):
    scope = 'module'

    def setUp(self, request):
        from api import logger as log
        self._logmod = log

        @memoized
        class _FakeLogger(object):
            logged = None

            def log(self, *args, **kwargs):
                print 'Log args=%r kwargs=%r' % (args, kwargs)
                self.logged = (args, kwargs)

        self._origLogger = log.Logger
        log.Logger = _FakeLogger

        return log.Logger()

    def tearDown(self, request, fakeLogger):  # @UnusedVariable
        self._logmod.Logger = self._origLogger


def testLogWrapper(fakeLogger):
    from api import logger as log

    # Check basic logging without wrapping
    log.debug('some debug')
    assert fakeLogger.logged[0][1:] == (-1, 'some debug')
    assert fakeLogger.logged[1] == {}

    # Check wrapped logging
    log_w = log.makeLogger(source='some src [port]')
    log_w.debug('some debug #2')
    assert fakeLogger.logged == (('some src [port]', -1, 'some debug #2'), {})

    # Check overriding source of wrapped logger
    log_w.debug('some debug #3', source='other src')
    assert fakeLogger.logged == (('other src', -1, 'some debug #3'), {})
