import os
from kernel.util.functional import memoized


INVALID_NAME = -1
RUNNING = 0
FINISHED = 1


@memoized
def ProcManClass():
    ns = os.getenv('SKYNET_PROCMAN_NAMESPACE', 'skynet')
    from api.skycore import ServiceManager
    return ServiceManager().get_service_python_api(ns, 'procman')


def ProcMan():
    return ProcManClass()()


class ProcManException(Exception):
    def __init__(self, code=-1, str="Not defined in __init__"):
        self.code = code
        self.descr = str

    def __str__(self):
        return "%d:[%s]" % (self.code, self.descr)

    def __repr__(self):
        return "{}({!r}, {!r})".format(self.__class__.__name__, self.code, self.descr)


class ProcessLookupException(ProcManException):
    pass


class UpdateContextException(ProcManException):
    pass
