#!/usr/bin/env python

from pytest import mark

import api.procman
import sys
import time
import signal


@mark.xfail
def testProcCreation(p, cmdline, keeprunning):

    #import ipdb; ipdb.set_trace()

    print "==== Testing process creation ===="
    print "==== cmdline[%s], keeprunning[%s] ====" % (cmdline, keeprunning)

    try:
        #h = p.create(cmdline, keeprunning=keeprunning, username='skynet')
        h = p.create(cmdline, keeprunning=keeprunning)
        print "Process handle[%s]" % h
        stat = h.running()
        data = h.stat()
        uuid = data['uuid']
        if not stat:
            print "Error, process is not running!"
            return 1
        print "Process data[%s]" % data
        print "Process valid[%s]" % p.is_valid(uuid)
        restarts = len(data['retcodes']) - 1
        time.sleep(2)
        sig = signal.SIGINT
        #sig = 'SIGINT'
        print "Sending", sig
        h.send_signal(sig)
        while True:
            stat = h.running()
            data = h.stat()
            if keeprunning:
                if not stat:
                    print "Error! Not running (%d)" % stat
                    return 1
                else:
                    restarts1 = len(data['retcodes']) - 1
                    if restarts1 > restarts:
                        print "Restarted"
                        print "Process data[%s]" % data
                        h.keepRunning(False)
                        h.send_signal(sig)
                        keeprunning = False
                        continue
                    else:
                        print "Not restarted yet..."
            else:
                if not stat:
                    print "Stopped (%d)" % stat
                    break
                else:
                    restarts1 = len(data['retcodes']) - 1
                    print "Still running..."
                    if restarts1 > restarts + 1:
                        print "And has restarted"
                        return 1
            time.sleep(1)
        print "Process valid[%s]" % p.is_valid(uuid)

        if keeprunning:
            h.kill()

        return 0
    except api.procman.ProcManException, e:
        print "Error while operating with ProcMan, [%s]" % e
        return 1


def ok(a, b):
    if (b != 0):
        print "Failed"
    return a and (b == 0)


def main():
    p = api.procman.ProcMan()
    pmrunning = p.ping()
    print "Manager running[%s]" % pmrunning

    if pmrunning:
#        cmdline = ['ping', 'localhost']
        cmdline = ['yes']
        #cmdline = ['echo', 'ololo']
        res = True
        res = ok(res, testProcCreation(p, cmdline, True))
        res = ok(res, testProcCreation(p, cmdline, False))
        #return 0 if res else 1

        #print "Stopping daemon..."
        #stopres = p.stop_daemon(0)
        #if not stopres:
        #    print "Error stopping daemon..."
        #    return 1
        print "Ok" if res else "Some tests failed"

        return 0 if res else 1
    else:
        return 1


if __name__ == '__main__':
    sys.exit(main())
