# -*- coding: utf-8 -*-
"""
Внутреннее API для DNS-запросов с пререзолвингом.
"""

__author__ = 'torkve'


class Resolver(object):
    def resolve(self, host, port):
        task = [host]
        result = self.request(task)[host]
        if isinstance(result, list):
            return [x[:4] + ((x[4][:1] + (port,) + x[4][2:]),) for x in result]  # replace port
        else:
            raise result

    def resolve_many(self, hosts):
        task = list(hosts)
        return self.request(task)

    def request(self, task):
        raise NotImplementedError


class UdpResolver(Resolver):
    def __init__(self):
        import socket

        self.sock = socket.socket(socket.AF_INET, socket.SOCK_DGRAM)
        self.addr = ('127.0.0.1', int(_get_api(UDP)))

    def request(self, task):
        from cPickle import dumps, loads, HIGHEST_PROTOCOL
        task = dumps(task, HIGHEST_PROTOCOL)
        self.sock.sendto(task, self.addr)
        result = self.sock.recv(8 * 1024)
        try:
            return loads(result)
        except EOFError:
            raise RuntimeError("too much data")


class UnixResolver(Resolver):
    def __init__(self):
        self.sock = None
        self.reader = None

        self.connect()

    def connect(self):
        if self.sock is not None:
            return

        import socket
        from cPickle import Unpickler

        self.sock = socket.socket(socket.AF_UNIX, socket.SOCK_STREAM)
        self.reader = Unpickler(self.sock.makefile('rb', 8 * 1024))

        addr = _get_api(UDS)
        self.sock.connect(addr)

    def close(self):
        self.sock.close()
        self.sock = None
        self.reader = None

    def request(self, task):
        from cPickle import dumps, HIGHEST_PROTOCOL
        task = dumps(task, HIGHEST_PROTOCOL)

        self.connect()
        try:
            self.sock.sendall(task)
            return self.reader.load()
        except EnvironmentError:
            self.close()
            raise


UDP = 'udp'
UDS = 'uds'


def _get_api(kind):
    import os
    ns = os.getenv('SKYNET_RESOLVER_NAMESPACE', 'skynet')

    from api.skycore import ServiceManager

    return ServiceManager().get_service_api(ns, 'resolver', kind)
