from kernel.util.errors import SkynetBaseError


__all__ = [
    'SkycoreError',
    'NotRunningError',
    'CallTimeout',
    'PathError',
    'ConfigNotReadyError',
    'AuthorizationError',
    'NamespaceError',
    'ServiceNotFoundError'
]


class SkycoreError(SkynetBaseError):
    """ Base class for all skycore errors. """
    def __init__(self, message=None):
        SkynetBaseError.__init__(self, message=str(message))


class NotRunningError(SkycoreError):
    """ This will indicate that service is not started. """


class CallTimeout(SkycoreError):
    """ This will indicate that timeout occurs on some operations. """


class PathError(SkycoreError):
    """ Error which indicates that queried section is not found. """


class ConfigNotReadyError(SkycoreError):
    """ Error which indicates that registry file is missing yet. Try it later. """


class AuthorizationError(SkycoreError):
    """ Error which indicates that operation is not permitted for non-authorized users. """


class NamespaceError(SkycoreError):
    """ Error which indicates that specified namespace is not found. """


class ServiceNotFoundError(SkycoreError):
    """ Error which indicates that specified service is not found. """
