# Список доступных конфигураций (sky listconf)

Возвращает список конфигураций для заданного в команде сервиса.

[Формат запуска](sky-listconf.md#request-format)
[Формат вывода](sky-listconf.md#response-format)
[Распространенные ошибки (Вики)](https://wiki.yandex-team.ru/skynet/FAQ2/#naiboleeverojatnyeoshibkiichtosnimidelat)

## Формат запуска {#request-format}

#### sky listconf

Команда без параметров возвращает набор всех доступных конфигураций CMS-сервиса. Обеспечивает обратную совместимость.

```
sky listconf
```

#### sky listconf <название сервиса>

Команда возвращает список всех доступных конфигураций заданного сервиса и информацию о состоянии этих конфигураций.

```
sky listconf <название сервиса>
```

{% cut "Возможные ключи и значения" %}

#|
|| **Ключ** | **Описание** | **Признак обязательности, ограничения** ||
|| `название сервиса` | Название сервиса в [Nanny](https://wiki.yandex-team.ru/runtime-cloud/nanny/), для которого запрашиваются доступные конфигурации. | Необязательный.
|#

{% endcut %}

## Формат вывода {#response-format}

Если в команде не указан сервис, то возвращается список названий всех конфигураций CMS-сервиса без какой-либо дополнительной информации.

Формат вывода при заданном сервисе (`sky listconf <название сервиса>`):

```
State                       (  A  /  I  /  T  )              Configuration name
--------------------------------------------------------------------------------------
<Статус конфигурации>         <Количество инстансов>         <Название конфигурации>
                      Активных(A)/Установленных(I)/Всего(T) 

```

> Команда возвращает список всех конфигураций сервиса service_for_torkve и информацию об их состоянии:
> 
> ```
> sky listconf service_for_torkve
> ```
> 
> {% include [response-format-the-following-answer](_includes/sky-list/id-response-format/the-following-answer.md) %}
> 
> 
> ```
> 
> State               (  A / I  / T  )            Configuration name
> --------------------------------------------------------------------------------
> INSTALLED           (  0 / 10 / 10 )            service_for_torkve-1524855432933
> ACTIVE              ( 10 / 10 / 10 )            service_for_torkve-1529425771851
> 
> ```

#### Узнайте больше

* [Распространенные ошибки](https://wiki.yandex-team.ru/skynet/FAQ1/#naiboleeverojatnyeoshibkiichtosnimidelat)