# Конфигурация сервисов

Для установки сервиса Skynet на сервер необходимо, чтобы в правилах сервиса в секции [skynet.skycore.namespaces.skynet](https://genisys.yandex-team.ru/sections/skynet.skycore.namespaces.skynet) (**skynet** → **skycore** → **namespaces** → **skynet** → **&lt;название сервиса>**) был указан хост сервера. Чтобы установить или удалить сервис с сервера напишите на рассылку [skynet@yandex-team.ru](mailto:skynet@yandex-team.ru).

Сервисы {{ serviceName }} устанавливаются и запускаются в соответствии с конфигурацией, определяемой в секции **skynet** → **services** ([https://genisys.yandex-team.ru/sections/skynet.services](https://genisys.yandex-team.ru/sections/skynet.services)) сервиса {{ deploy-and-configService }}.

Конфигурация сервисов задается в формате YAML. Каждому серверу по умолчанию ставится в соответствие базовая конфигурация сервисов (`DEFAULT`). Если для набора серверов требуется специфичная конфигурация одного или нескольких сервисов, то для каждого из них [создается правило конфигурации](#adding-service-configuration). Приоритет конфигурации сервиса тем выше, чем выше она расположена в списке. В базовой конфигурации заменяются только те фрагменты, которые переопределены в создаваемой (см. [пример](#config-example)).

Конфигурация сервисов запрашивается в {{ deploy-and-configService }} дистрибутивом `skynet.bin`.

{% note warning %}

[Создать правило](#adding-service-configuration) может только владелец секции в {{ deploy-and-configService }}. В случае с секцией [skynet.services](https://genisys.yandex-team.ru/sections/skynet.services) это группа [SkyNet](https://staff.yandex-team.ru/departments/yandex_search_tech_searchinfradev_skynet). Чтобы внести изменения в правила конфигурации сервиса, напишите на рассылку [skynet@yandex-team.ru](mailto:skynet@yandex-team.ru). [Редактировать конфигурацию](#editing-service-config) может сотрудник, имеющий соответствующий доступ (выдает владелец секции в поле [Editors](#editors)).

{% endnote %}

[Создание правила конфигурации сервиса](#adding-service-configuration)

[Редактирование конфигурации сервиса](#editing-service-config)

[Удаление конфигурации сервиса](#deleting-service-config)

## Создание правила конфигурации сервиса {#adding-service-configuration}

Процедура выполняется, если для набора серверов требуется задать конфигурацию сервиса, отличную от используемой по умолчанию.

Чтобы создать правило:

1. Перейдите в секцию **skynet** → **services** ([https://genisys.yandex-team.ru/sections/skynet.services](https://genisys.yandex-team.ru/sections/skynet.services)).
    
1. Выберите требуемый сервис из списка и нажмите кнопку ![alt_text](./_assets/b-add.png) в шапке таблицы с правилами для данного сервиса.
    
1. Заполните поля и нажмите кнопку **Create**.
    
    {% cut "Описание полей" %}

    Поле | Описание | Признак обязательности
    :--- | :--- | :---
    **Name** | Название правила. | Обязательное.
    **Description** | Описание создаваемого правила в свободной форме. | Необязательное.
    **Editors** | Сотрудник или группа сотрудников Яндекса, которые имеют доступ на редактирование данного правила.<br/><br/>По умолчанию права на редактирование правила наследуются с верхнего уровня.<br/><br/>Можно указать:<br/><br/>* отдельного сотрудника: `<логин>`;<br/>* группу на Стаффе: `group:svc_<идентификатор группы>`;<br/>* группу в сервисе ABC: `group:<идентификатор группы>`.<br/><br/>Если доступ на редактирование необходимо дать нескольким сотрудникам/группам, укажите их через пробел. | Необязательное.
    **Host list** | Список хостов, к которым должно применяться правило.<br/><br/>Вы можете применить правило ко всем хостам (**Apply to all hosts**) или указать список в формате [калькулятора Блинова](https://doc.yandex-team.ru/generated/skynet/sky/blinovcalc.html) (**Specify selector of hosts to apply to** → **Selector**).<br/><br/>Списки, хранящиеся в формате калькулятора Блинова, пересчитываются с заданной периодичностью. Поэтому задержка между изменением содержимого групп и применением соответствующих изменений на группах серверов может занимать до четырех часов. | Обязательное.
    **Config** | Данные, определяющие конфигурацию. Задаются в формате YAML.<br/><br/>Заменяются только указанные лепестки базовой конфигурации сервиса (см. [пример](#config-example)). | Обязательное.

    {% endcut %}
    
1. Переместите правило по списку (по умолчанию новое правило помещается в конец). Для этого нажмите кнопку ![alt_text](./_assets/b-reorder.png) в шапке таблицы, переместите правило в требуемую часть списка и сохраните изменения (кнопка **Save new order**). Приоритет правила тем выше, чем выше оно расположено.

В результате в {{ deploy-and-configService }} зарегистрирована информация об изменениях конфигурации сервиса, которые должны быть применены к указанной группе серверов.

{% note info %}

Скорость обновления сервисов {{ serviceName }} зависит от настроек в {{ deploy-and-configService }} (**skynet** → **skycore** → **config** → **&lt;название правила>**). Изменять данные настройки могут только сотрудники группы [SkyNet](https://staff.yandex-team.ru/departments/yandex_search_tech_searchinfradev_skynet).

{% endnote %}

   #### Пример конфигурации сервиса {#config-example}
   
   Пусть в качестве конфигурации, используемой по умолчанию для сервиса, задана следующая конструкция:
   
   ```
   service:
      enabled: true
      namespace: [skynet]
      cgroup: skynet/services/cqudp
   
   config:
    server:
         user: skynet
         LogLevel: INFO
         TempDir: '/var/tmp/{userName}'
         Tmpfs: []
   ```
   
   Для хоста `somehost` требуется заменить значение ключа `Tmpfs` на <q>- ['${server.TempDir}/cqudp', 128M]</q>.
   
   При регистрации конфигурации задаются значения полей, приведенные в таблице ниже.

   Поле | Значение
   :--- | :---
   **Name** | `tmpfs on somehost`<br/><br/>Может быть задано любое название.
   **Host list** | `h@somehost`
   **Config** | `config:`<br/>`   server:`<br/>`      Tmpfs:`<br/>`         - ['${server.TempDir}/cqudp', 128M]`

   В результате для хоста `somehost` конфигурация принимает вид:
   
   ```
   config:
       server:
         user: skynet
         LogLevel: INFO
         TempDir: '/var/tmp/{userName}'
         Tmpfs: 
            - ['${server.TempDir}/cqudp', 128M]
   ```

## Редактирование конфигурации сервиса {#editing-service-config}

Вы можете изменить созданную ранее конфигурацию сервиса. Для этого:

1. Выберите из списка правило, определяющее конфигурацию сервиса: **skynet** → **services** → **&lt;название сервиса>** → **&lt;название правила>**.
    
1. Отредактируйте параметры:
    
    * Содержание конфигурации (параметр **Config**). Нажмите кнопку **Edit**, внесите необходимые изменения и сохраните их.
    
    * Другие параметры (**Description**, **Editors**, **Host list**). Нажмите кнопку ![alt_text](./_assets/b-edit.png) рядом с названием правила, укажите новые значения и сохраните изменения.
    
1. _(опц.)_ Переместите правило по списку (копка ![alt_text](./_assets/b-reorder.png)) и сохраните изменения. Приоритет правила тем выше, чем выше оно расположено.
    
В результате в {{ deploy-and-configService }} сохранятся сведения об актуальной конфигурации сервиса для соответствующей группы серверов. Для перезапуска сервисов в соответствии с указанными свойствами может потребоваться до четырех часов.

Посмотреть историю изменений можно по ссылке **changes history** под названием правила.

## Удаление конфигурации сервиса {#deleting-service-config}

Чтобы удалить конфигурацию сервиса:

1. Выберите требуемый сервис из списка: **skynet** → **services** → **&lt;название сервиса>**.
    
1. Выберите правило из списка и нажмите кнопку ![alt_text](./_assets/b-delete.png).
    
1. Подтвердите намерение удалить правило (кнопка **Yes**).
    
В результате из {{ deploy-and-configService }} удаляется запись о конфигурации сервиса для заданной группы серверов. Вместе нее для группы применяется другое правило, находящееся ниже в списке, в общем случае — правило, используемое по умолчанию (`DEFAULT`).
