# Версия Skynet

Версии {{ serviceName }}, которые должны быть установлены на серверах, определяются в сервисе {{ deploy-and-configService }} с помощью правил ([https://genisys.yandex-team.ru/sections/skynet.versions](https://genisys.yandex-team.ru/sections/skynet.versions)).

Приоритет правила тем выше, чем выше оно находится в списке. Если один сервер определен в нескольких правилах, приоритет отдается тому, которое находится выше в списке. Если сервер не указан ни в одном из правил, к нему применяется правило `DEFAULT`.

{% note warning %}

[Создать](#adding-skynet-version) или [отредактировать](#editing-skynet-version) правило может только владелец секции в {{ deploy-and-configService }} (owner). В случае с секцией [skynet.versions](https://genisys.yandex-team.ru/sections/skynet.versions) это группа [SkyNet](https://staff.yandex-team.ru/departments/yandex_search_tech_searchinfradev_skynet). Чтобы внести изменения в правила данной секции (кроме версии дистрибутива `skynet.bin`), напишите на рассылку [skynet@yandex-team.ru](mailto:skynet@yandex-team.ru). Версию `skynet.bin` может [изменить](#editing-skynet-version) сотрудник, имеющий доступ к редактированию правила (доступ выдает владелец секции в поле **Editors**).

{% endnote %}

[Создание нового правила](#adding-skynet-version)

[Редактирование правил](#editing-skynet-version)

[Удаление правила](#deleting-a-rule)

Также указать версию Skynet, которую необходимо установить на сервер, можно с помощью [алиаса](aliases.md).

## Создание нового правила {#adding-skynet-version}

Чтобы создать правило:

1. Перейдите в секцию **skynet** → **versions** ([https://genisys.yandex-team.ru/sections/skynet.versions](https://genisys.yandex-team.ru/sections/skynet.versions)).
    
1. Нажмите кнопку ![alt_text](./_assets/b-add.png) в шапке таблицы с правилами.
    
1. Заполните поля и нажмите кнопку **Create**.
    
    {% cut "Описание полей" %}

    Поле | Описание | Признак обязательности
    :--- | :--- | :---
    **Name** | Название правила. | Обязательное.
    **Description** | Описание создаваемого правила в свободной форме. | Необязательное.
    **Editors** | Сотрудник или группа сотрудников Яндекса, которые имеют доступ на редактирование данного правила.<br/><br/>По умолчанию права на редактирование правила наследуются с верхнего уровня.<br/><br/>Можно указать:<br/><br/>* отдельного сотрудника: `<логин>`;<br/>* группу на Стаффе: `group:svc_<идентификатор группы>`;<br/>* группу в сервисе ABC: `group:<идентификатор группы>`.<br/><br/>Если доступ на редактирование необходимо дать нескольким сотрудникам/группам, укажите их через пробел. | Необязательное.
    **Host list** | Список хостов, к которым должно применяться правило.<br/><br/>Вы можете применить правило ко всем хостам (**Apply to all hosts**) или указать список в формате [калькулятора Блинова](https://doc.yandex-team.ru/generated/skynet/sky/blinovcalc.html) (**Specify selector of hosts to apply to** → **Selector**).<br/><br/>Списки, хранящиеся в формате калькулятора Блинова, пересчитываются с заданной периодичностью. Поэтому задержка между изменением содержимого групп и применением соответствующих изменений на группах серверов может занимать до четырех часов. | Обязательное.
    **Sandbox Resource** | Версия дистрибутива `skynet.bin`, которая будет использоваться при установке на группе серверов. Определяется идентификатором ресурса в Sandbox.<br/><br/>Вы можете:<br/><br/>* выбрать требуемую версию из списка ста последних релизов Skynet (**Choose from resources released lately** → **Released resource**);<br/><br/>* вручную ввести идентификатор ресурса, содержащего требуемую версию Skynet (**Specify resource id** → **Resource id**);<br/><br/>* указать алиас, из параметров которого будет браться версия дистрибутива `skynet.bin` (**By released resource alias** → **Alias**). | Обязательное.

    {% endcut %}
    
1. Переместите правило по списку (по умолчанию новое правило помещается в конец). Для этого нажмите кнопку ![alt_text](./_assets/b-reorder.png) в шапке таблицы, переместите правило в требуемую часть списка и сохраните изменения (кнопка **Save new order**). Приоритет правила тем выше, чем выше оно расположено.
    
В результате в {{ deploy-and-configService }} регистрируется информация о правиле, определяющем версию {{ serviceName }}, которая должна быть установлена на указанных серверах.

{% note info %}

Скорость обновления {{ serviceName }} зависит от частоты запуска утилиты [gosky](gosky-install.md). Для ускорения рекомендуется перезапустить утилиту.

{% endnote %}

## Редактирование правил {#editing-skynet-version}

Вы можете изменить параметры существующего правила, определяющего версию {{ serviceName }}. Для этого:

1. Выберите требуемое правило из списка: **skynet** → **versions** → **&lt;название правила>**.
    
1. Отредактируйте значения параметров:
    
    * Версия дистрибутива `skynet.bin` (параметр **Sandbox resource**).
    * Другие параметры (**Description**, **Editors**, **Host list**). Нажмите кнопку ![alt_text](./_assets/b-edit.png) рядом с названием правила, укажите новые значения и сохраните изменения.
    
1. _(опц.)_ Переместите правило по списку (кнопка ![alt_text](./_assets/b-reorder.png)) и сохраните изменения. Приоритет правила тем выше, чем выше оно расположено.
    
В результате в {{ deploy-and-configService }} обновлены значения параметров правила и/или очередность правил.

Посмотреть историю изменений можно по ссылке **changes history** под названием правила.

## Удаление правила {#deleting-a-rule}

Чтобы удалить правило:

1. Выберите требуемое правило из списка: **skynet** → **versions** → **&lt;название правила>**.
    
1. Нажмите кнопку ![alt_text](./_assets/b-delete.png) и подтвердите намерение удалить правило (кнопка **Yes**).

В результате из {{ deploy-and-configService }} удалены сведения о правиле.

Группа серверов может быть определена в одном или нескольких дополнительных правилах. Поэтому при удалении одного из правил в течение четырех часов версия {{ serviceName }} для данных серверов заменяется на ту, которая определена в наиболее высоко расположенном правиле. Если группа серверов не определена в прочих правилах, устанавливается версия, указанная в правиле `DEFAULT`.

### Узнайте больше
* [Процедура обновления версии Skynet (Вики)](https://wiki.yandex-team.ru/Skynet/HowToUpdate/)
