# Аутентификация

Возможность управлять клиентскими экземплярами Skynet предоставляется автоматически при наличии SSH-доступа к целевому серверу. Аутентификация обеспечивается с помощью CAuth. Доступ до серверов запрашивается через [IDM](https://idm.yandex-team.ru/).

Способы доставки публичных ключей до целевого сервера:
- Агент CAuth. Регулярно проверяет список публичных ключей, которые должны быть доставлены/удалены, и раскладывает по домашним каталогам пользователей.
    
- Сервис `keychain`. Используется, если отсутствует информации о наличии/работоспособности агента CAuth на целевом сервере. Регулярно проверяет список публичных ключей, которые должны быть доставлены/удалены, и сохраняет на целевом сервере.
    
    Путь и формат названия ключей на целевом сервере:
    
    ```
    /Berkanavt/supervisor/etc/auth/<имя пользователя>/<имя пользователя>.cauth.<порядковый номер ключа>.public
    ```
    
    Например, если у пользователя <q>ironman</q> два ключа, то они будут доступны по следующим путям:
    
    ```
    /Berkanavt/supervisor/etc/auth/ironman/ironman.cauth.00.public
    /Berkanavt/supervisor/etc/auth/ironman/ironman.cauth.01.public
    ```

### Узнайте больше
- [А как правильно настроить firewall? (Вики)](https://wiki.yandex-team.ru/Skynet/FAQ2/#akakpravilnonastroitfirewall)
- [Описание CAuth (Вики)](https://wiki.yandex-team.ru/security/CAuth/)

## Эмуляция ssh-agent {#ssh-agent-emulation}

Ключи, доступные пользователю на клиентском экземпляре сервисов {{ serviceName }}, могут также быть использованы на удаленном сервере в виде эмуляции ssh-agent. Соответствующий ssh-agent доступен только тому пользователю, который запросил эмуляцию.

{% note alert %}

На эмулируемый ssh-agent накладываются следующие ограничения:

- Поддерживается только протокол SSH версии 2.0 и выше.
- Доступны только методы  и .

{% endnote %}



## Особенности при использовании portoshell {#portoshell-peculiarities}

Использование portoshell возможно при наличии незашифрованного приватного ключа. Ключ должен быть размещен в каталоге `~/.ssh` или быть доступен для ssh-agent в режиме [эмуляции](#ssh-agent-emulation).

Общий алгоритм аутентификации:

1. Пользователь обращается к хосту с Porto-контейнером.
1. portoshell запрашивает у локального экземпляра Звездолета список доступных слотов.
1. portoshell обращается к требуемому слоту на целевом сервере.
1. Слот направляет аутентификационные данные в Nanny или Qloud (в зависимости от режима авторизации).
1. Nanny или Qloud (в зависимости от режима авторизации) возвращают публичный ключ, если пользователю разрешен доступ в указанный слот.
1. Публичный и личный ключ проверяются на совпадение.

В случае успешной аутентификации пользователю предоставляется доступ к указанном слоту.

### Узнайте больше
- [portoshell](public-services_portoshell.dita#public-services_portoshell)
- [Звездолет. Общее описание](https://doc.yandex-team.ru/Search/iss-ref)