# Вопросы и ответы

## **Наиболее вероятные ошибки и что с ними делать** {#errors}

### Skybone (aka Copier) и sky get {#skybone-skyget}


{% cut "sky get не работает с папкой, примонтированной через arc" %}

Причина этой ошибки: копир перед скачиванием проверяет, что у пользователя skynet, есть доступ к папке, куда скачивается ресурс, для последующей раздачи. Если доступа нет, то копир предполагает, что копир запущен в контейнере port/lxc и пытается сконвертировать пути. Это привод к неожиданной ошибке:


```
Error: CopierError: Unable to convert destination path (/some/path/to/directory/in/arc) thru porto/lxc {14834:26706}
```

Как диагностировать и лечить

По умолчанию arc примонтируется под конкретным пользователем. Надо использовать опцию --allow-other:
` arc mount --allow-other `


```
arc mount --help 
  --allow-root           allow root access to the mounted filesystem; cannot be used with --allow-other (default: 0)
  --allow-other          all users (including root) can access the files in FUSE; cannot be used with --allow-root (default: 0)
```

{% endcut %}



### Cqudp и sky run {#cqudp-skyrun}


{% cut "Authentication failure" %}

Причина этой ошибки: отсутствие подходящих SSH-ключей.
Как диагностировать и лечить:
1. Убедитесь, что у вас есть ssh-доступ в [IDM](https://idm.yandex-team.ru/) на тот хост, который возвращает ошибку. Если доступа нет, его надо запросить. На хосте права и ключи появляются в течение примерно 15-20 минут после аппрува.
1. Убедитесь, что у вас именно в той консоли, в которой вы пытаетесь использовать cqudp (или sky run) доступны SSH-ключи, зарегистрированные на стаффе.

   Приватные ключи должны лежать в ` ~/.ssh/ ` или быть доступны в ssh-агенте. Наличие ключей в ssh-агенте можно проверить командой ` ssh-add -l `.

   Если вы пользуетесь приватными ключами, а не ssh-агентом, убедитесь, что на каталог ` ~/.ssh ` и сам приватный ключ выставлены правильные права доступа: 0700 для ` ~/.ssh ` и 0600 для приватного ключа в нем.
   
1. Проверьте, что ключи в правильном формате: поддерживаются RSA, DSA и ECDSA-ключи. Если вы не пользуетесь ssh-агентом, ключи не должны быть запаролены (поэтому рекомендуем добавить их в ssh-агент).
1. Если всё вышеупомянутое выполняется, но ошибка всё равно возвращается, напишите в рассылку [skynet@yandex-team.ru](mailto:skynet@yandex-team.ru). Для диагностики надо предоставить имя пользователя, под которым выполнялся запрос, вывод команды ` ssh-add -l `, имена хостов с которого и на который выполнялось обращение, а также время, когда был выполнен запрос.

{% endcut %}



{% cut "Authorization failure" %}

Причина ошибки: проверка ключей пользователя прошла успешно, но машина запрещает пользователю вход.
Как диагностировать и лечить:
1. Поскольку разрешение на вход проверяется средствами подсистемы [PAM](https://en.wikipedia.org/wiki/Pluggable_authentication_module), которая в свою очередь получает данные из [LDAP](https://en.wikipedia.org/wiki/Lightweight_Directory_Access_Protocol) по сети, иногда эта ошибка вызвана временными сетевыми проблемами. Попробуйте повторить обращение через 30-120 секунд.
1. Убедитесь, что у вас есть ssh-доступ в [IDM](https://idm.yandex-team.ru/) на тот хост, который возвращает ошибку. Если доступа нет, его надо запросить. На хосте права появляются в течение примерно 15-20 минут после аппрува.
1. Если ошибка сохраняется, обратитесь к администраторам машины, на которую выполнялся запрос. Как правило, администраторы — это [поддержка RTC](https://wiki.yandex-team.ru/runtime-cloud/rtc-support/). Для диагностики надо будет предоставить полный текст ошибки, имена хостов с которого и на который выполнялось обращение, а также время, когда был выполнен запрос.

{% endcut %}



{% cut "Host is silent" %}

Причина ошибки: от удаленной машины нет ответов.

Как диагностировать и лечить:

1. Первая возможная причина ошибки: отсутствие сетевой связности между машинами. Для общения между машинами должны быть открыты все входящие и исходящие UDP-пакеты с портов и на порты 10041 и всего эфемерного диапазона (>=32768). Если вы пытаетесь идти с локальной машины (ноутбука), то с вероятностью 99% такого доступа нет, лучше используйте машины в облаке. Если машина не локальная, убедитесь, что соответствующие доступы есть в [Puncher](https://puncher.yandex-team.ru/).

   Для базовой проверки связности также можно использовать команду ` skyctl run-script skynet cqudp buscheck remote.host.yandex.net `
1. Ошибка может быть вызвана чрезмерной загрузкой удаленной машины. Для диагностики попробуйте зайти на эту машину по ssh и посмотреть текущий load average (например, командой ` uptime `).
1. Убедитесь, что на удаленной машине запущен cqudp: команда ` skyctl check skynet cqudp ` должна выдавать статус RUNNING или PRERUNNING.
1. Если всё вышеперечисленное проверено, а ошибка сохраняется, напишите в рассылку [skynet@yandex-team.ru](mailto:skynet@yandex-team.ru). Для диагностики надо предоставить имена хостов с которого и на который выполнялось обращение, а также время, когда был выполнен запрос.

{% endcut %}



{% cut "Где искать логи" %}

* На локальной машине в ` /var/log/skynet/cqudp-client.log `
* На удаленной машине в ` /var/log/skynet/cqudp-server.log ` и ` /var/log/skynet/cqudp-child.log `

{% endcut %}



### Portoshell {#portoshell}
А также ` sky portoshell ` и ssh в контейнеры.



{% cut "Connection timed out" %}

Возможные причины ошибки две:
1. Нет сетевых дырок.
1. Не запущен portoshell в том контейнере, в который вы пытаетесь получить доступ.

Способы лечения:
1. Если вы пытаетесь получить доступ через хост-систему (командой ` sky portoshell ` или ` ssh -p10046 ... `):

   * Убедитесь, что у вас есть доступы в [Puncher](http://puncher.yandex-team.ru/) на удаленный хост на TCP-порт 10045 или 10046 соответственно.

1. Если вы пытаетесь получить доступ через сеть контейнера (` ssh container.hostname `):

   * Убедитесь, что у вас есть доступы в [Puncher](http://puncher.yandex-team.ru/) в проектную сеть контейнера на TCP-порт 22.
   * Убедитесь, что в вашем сервисе во вкладке instance spec включена опция ` ssh (whether to start ssh in instance network namespace or not) `.

Если ничего из вышеперечисленного не помогает, обратитесь в [поддержку RTC](https://wiki.yandex-team.ru/runtime-cloud/rtc-support/).

{% endcut %}



{% cut "Где искать логи" %}

На хост-системе машины с контейнером в ` /var/log/skynet/portoshell.log `

{% endcut %}



### Skycore {#skycore}


{% cut "Как проверить статус сервисов на машине" %}

` skyctl check `

{% endcut %}



{% cut "Как понимать статусы сервисов" %}

* PRERUNNING, RUNNING — это хорошие статусы. Сервис запущен и работает.
* STARTING — сервис еще запускается, его работоспособность неизвестна.
* STOPPING, KILLLING, CLEANUP, STOPPED — сервис в данный момент останавливается или уже остановлен (для перезапуска, обновления или потому что просто попросили).
* PREFAIL — сервис работает, но не ответил положительно на чек, пока ничего не происходит, ждем дальнейших ответов на чеки.
* COOLDOWN — сервис так часто падал, что перед дальнейшими попытками запуска был остановлен на 15-120 минут.
* DEPENDENCIES_WAIT — (редкий статус) сервис имеет слабую зависимость от другого сервиса и сейчас некоторое время ждет его запуска.

{% endcut %}



{% cut "Как перезапустить сервис" %}

Обычно вы этого хотите, если сервис находится в статусе COOLDOWN, вы устранили причину его падений и не хотите ждать, пока он поднимется автоматически.

```
skyctl restart <namespacename> <servicename>
```

В остальных случаях скорее всего лучше дождаться, пока его поднимет автоматика.

{% endcut %}



{% cut "Где искать логи" %}

* Логи skycore: ` /var/log/skycore/skycore.log `
* stderr сервисов: ` /var/log/skycore/<namespace>/<service>/<service>.log `
* Логи чеков сервисов: ` /var/log/skycore/<namespace>/<service>/<service>-check.log `
* Логи самих сервисов: зависят от сервиса, большинство сервисов скайнета пишут логи в ` /var/log/skynet/ `

{% endcut %}



## **Про деплой Skynet** {#skynet-deploy}


### Как Skynet попадает на машину? {#skynet-install}


{% cut "ответ" %}

Сам Skynet на машину приехать не может. Для этого необходимо установить утилиту ` gosky ` (пакет ` yandex-gosky ` доступен в репозитории ` common /stable/all/ `). 

Перед запуском ` gosky ` необходимо [настроить firewall](https://wiki.yandex-team.ru/Skynet/new-faq/#akakpravilnonastroitfirewall). 

После установки запуск утилиты будет осуществляться по крону с заданной периодичностью (_раз в 10 минут_), чтобы проверить наличие новой версии Skynet. Также для ускорения установки можно вызвать ` gosky ` вручную, но необходимо иметь ` sudo ` (` sudo /Berkanavt/skynet/bin/gosky -f `).

{% note warning %}

После первой установки gosky skynet на машине появляется далеко не сразу:

   - макс. 10 минут уходит на первый запуск gosky, который и определит, что нужно поставить skynet на машину (если, конечно, перед этим gosky не запускали руками);
   - макс. 3 минуты уходит на скачивание skynet.bin, если скачивание идет по backbone;
   - макс. 5 минут уходит на первичную установку skynet.

   Итого: skynet гарантированно запустится через 20 минут после установки gosky.

{% endnote %}

{% endcut %}



### Как определяется, что новая версия Skynet доступна для установки? {#skynet-update}


{% cut "ответ" %}

Наличие новой версии для машины, где запущен ` gosky `, выясняется у Genisys. Происходит это с периодичностью (_раз в 10 минут_).

` gosky ` посылает HTTP запрос на 80-й порт ` genisys.yandex-team.ru `. В ответ получает информацию о версии Skynet, которая должна быть установлена на этой машине. Если новая версия имеется или ` gosky ` запущен первый раз, то ` gosky ` приносит на машину Skynet.bin и запускает его.

Если же Genisys по какой-либо причине не доступен, то Skynet просто не обновится.

{% endcut %}



### Что такое skynet.bin? {#skynet-bin}


{% cut "ответ" %}

` skynet.bin ` это инсталлятор Skynet, который представляет из себя bash-скрипт, содержащий в себе все зависимости Skynet (python и библиотеки для всех поддерживаемых ОС) и все сервисы, входящие в состав Skynet, например: procman, logger, hearbeat-client, copier. 

При запуске ` skynet.bin ` распаковывает и устанавливает только то, что должно быть установлено на машине. В случае если это не первичная установка, а обновление, то после установки перезапускаются только изменившиеся сервисы. 

Большинство сервисов skynet умеют перезапускаться незаметно для пользователя. Например, copier продолжит раздавать/скачивать, если были активные раздачи/скачивания, а cqudp продолжит выполнять пользовательские задачи, если они были запущены до перезапуска.

{% endcut %}



### Как skynet.bin узнает, что должно быть установлено на машине? {#skynet-config}


{% cut "ответ" %}

` skynet.bin `, так же как и ` gosky `, умеет ходить в Genisys по HTTP, но запрашивает не версию, а конфигурацию всех сервисов Skynet. В этой конфигурации и указано, должен ли такой-то сервис работать на данной машине и с какими настройками.

{% endcut %}



### Откуда gosky берет skynet.bin? {#gosky}


{% cut "ответ" %}

Изначально ` skynet.bin ` собирается в Sandbox и оттуда раздается. Скачивается он одним из трех способов (каждый следующий это fallback  в случае,  если скачивание предыдущим способом не получилось):

* С помощью Skynet Copier (это возможно, если Skynet уже был установлен и сервис Copier нормально функционирует).
* С помощью rsync.
* По HTTP напрямую с серверов Sandbox.

После скачивания несколько последних версий ` skynet.bin ` хранятся на машине и раздаются с помощью Skynet Copier для ускорения выкладки новой версии Skynet.

{% endcut %}



### А можно ли подменить skynet.bin? {#stand-in}


{% cut "ответ" %}

При получении информации о новой версии Skynet из Genisys ` gosky ` получает проверочную сумму MD5 и после скачивания ` skynet.bin ` проверяет, что получен именно тот файл, который  необходимо установить.

{% endcut %}



### Кто может сделать новый релиз skynet.bin в Sandbox? {#sandbox}


{% cut "ответ" %}

Новый релиз может сделать ограниченное число лиц, а именно:

* группа Skynet: [mocksoul@](https://staff.yandex-team.ru/mocksoul), [oplachkin@](https://staff.yandex-team.ru/oplachkin), [torkve@](https://staff.yandex-team.ru/torkve).

{% endcut %}



### А кто может выкатить новый релиз на группу машин? {#group}


{% cut "ответ" %}

Сейчас реализован нормальный ACL в Genisys.

Права на обновление версии skynet на определенной группе машин можно запросить через рассылку [skynet@](https://staff.yandex-team.ru/skynet)

{% endcut %}



### Что такое Genisys? {#genisys}


{% cut "ответ" %}

Genisys это не только название очередного фильма про Терминатора, но и название сервиса для деплоя и конфигурирования Skynet.

В более широком смысле он позволяет предоставлять конфиги произвольным наборам хостов.

{% endcut %}



### А можно установить skynet как-то попроще? {#quick-install}


{% cut "ответ" %}

{% note alert %}

Данный вариант более не доступен. Для новых релизов skynet пакеты больше не варятся, в связи с переходом всех потребителей на нормальный способ обновления через gosky.

{% endnote %}

Если вас по каким-либо причинам не устраивает стандартная схема установки и обновления skynet, то существует альтернативный способ.

Установка осуществляется с помощью мета-пакета. Сейчас доступен dep, в будущем также будет сделан rpm. Мета-пакет устанавливается из того же репозитория что и gosky: ` http://dist.yandex.ru/common/stable/all/ `.

Текущая версия: **yandex-skynet-releaseconf=15.5.16** (` apt-get install yandex-skynet-releaseconf `).

{% note warning %}

После установки мета-пакета gosky поставит на машину версию skynet, указанную в мета-пакете и авто-обновление будет выключено. Для последующего обновления skynet будет необходимо поставить на все машины новый мета-пакет руками.

{% endnote %}

{% endcut %}



## **Про Super Stable Skynet** {#super-stable-skynet}


### Что такое Super Stable Skynet? {#ss-skynet}


{% cut "ответ" %}

Super Stable Skynet это релиз с ограниченной функциональностью. То есть, в данном релизе включены не все сервисы, а у некоторых сервисов также ограничена функциональность. Основная цель - сделать skynet незаметным на машине (низкое потребление CPU и памяти) для выполнение одной единственной цели (о чем ниже)

{% endcut %}



### Какой набор сервисов входит в Super Stable Skynet? {#ss-services}


{% cut "ответ" %}

В Super Stable Skynet включены:
* **Procman**: сервис для запуска других сервисов skynet (умеет перезапускать упавшие сервисы).
* **Logger**: сервис, умеющий писать ротирующиеся раз в сутки логи (используется большинством сервисов skynet).
* **Heartbeat-client**: сервис, собирающий информацию на машине и отправляющий ее для последующей обработки в Hearbeat-server. Пересылаемая информация определяется набором плагинов, запускаемых на машине. В случае Super Stable Skynet этот набор выглядит так:

    - SkyInfo
    - GoskyVersion
    - HostInfo
    - InstanceUsage
    
  Детальную информацию о всех плагинах можно найти [здесь](https://beta.wiki.yandex-team.ru/Skynet/Services/Heartbeat/).
  
* **Copier**: изначально сервис предназначенный для копирования данных между серверами с использованием bittorrent протокола. В случае Super Stable Skynet, основное предназначение copier - эффективная установка и обновление skynet на машинах.

{% endcut %}



### А зачем это всё нужно? {#all}


{% cut "ответ" %}

По мотивам [Ресурсы надо считать. Skynet везде](https://clubs.at.yandex-team.ru/sysadmin/9809).

В рамках данной задачи Super Stable Skynet предназначен для внедрения на максимальное количество серверов Yandex. Основная цель - собирать информацию о использовании ресурсов на машинах с помощью плагина Heartbeat-client под кодовым названием [Usage].

{% endcut %}



### А как правильно настроить firewall? {#firewall}


{% cut "ответ" %}

Непонятное описание максимального набора доступов есть [здесь](http://doc.yandex-team.ru/Search/skynet-ag/concepts/access.xml).

Детальное описание используемых портов можно найти [здесь](https://wiki.yandex-team.ru/DljaAdminov/search/ports/#naznachenieportovskynet).


{% cut "Оптимальный набор доступов для Super Stable Skynet:" %}

| **Кто** | **Куда** | **Порт** | **Протокол** | **Зачем** | **Примечание** |
| --- | --- | --- | --- | --- | --- |
| Сopier | [Туда, откуда хотите скачивать копиром] | 6881..6999 | TCP | Эти порты используются копиром при скачивании | По умолчанию будет использоваться fastbone при его наличии на машине |
| gosky | proxy.sandbox.yandex-team.ru | 443 | TCP | Cкачивание skynet из proxy sandbox | Используется при обновлении skynet в случае отсутствия или неработоспособности копира на машине |
| gosky и skycore | балансер genisys.yandex-team.ru | 80, 443 | TCP | Получение информации о релизе и конфигурации skynet | Используется для обновления skynet и конфигурации  его сервисов |
| skynet.bin | балансер heartbeat.yandex-team.ru | 80 | TCP | Отправление отчетов напрямую, (сам skynet.bin отправляет отчет о том, что он поставился) | Позволяет послать отчет об установке skynet при неработающем heartbeat-client |
| резолвер | балансер c.yandex-team.ru | 80, 443 | TCP | Резолвинг сущностей кондуктора (группа, проект, тэг) | Позволяет использовать в калькуляторе Блинова кондукторные сущности [K@](https://staff.yandex-team.ru/K), [k@](https://staff.yandex-team.ru/k), [P@](https://staff.yandex-team.ru/P), [D@](https://staff.yandex-team.ru/D) |

Если хотите использовать cqudp, то надо еще немного настроить:
| **Кто** | **Куда** | **Порт** | **Протокол** | **Зачем** |
| --- | --- | --- | --- | --- |
| Cqudp | [Туда, куда хотите ходить с помощью cqudp] | 10040, 10041 | UDP | Эти порты используется для соединения между клиентом и серверами cqudp |
| Cqudp | [Туда, куда хотите ходить с помощью cqudp] | ephemeral range (32768+) | UDP | Для общения между клиентом и запущенными задачами |

{% endcut %}


  

{% cut "Минимально возможный (параноидальный) набор доступов для Super Stable Skynet:" %}

{% note alert %}

При этом гарантировано будет работать только обновление skynet с помощью мета-пакета и плагины heartbeat-client. Стандартное обновление с помощью gosky работать не будет

UPDATE: обновление с помощью gosky также будет работать, но только в случае свежего gosky, то есть начиная с версии > 2.0.0

{% endnote %}

| **Кто** | **Куда** | **Порт** | **Протокол** | **Зачем** | **Примечание** |
| --- | --- | --- | --- | --- | --- |
| gosky | балансер genisys.yandex-team.ru | 80, 443 | TCP | Получение информации о релизе skynet | Используется в gosky для обновления skynet |
| резолвер | балансер c.yandex-team.ru | 80, 443 | TCP | Резолвинг сущностей кондуктора (группа, проект, тэг) | Требуется для определения серверов heartbeat и трекеров копира |

{% endcut %}

{% endcut %}



## **Про всякое разное** {#other}


### У меня на машине нет сервиса XXX, но очень хочется, что мне делать? {#xxx}


{% cut "ответ" %}

{% note warning %}

Данный способ работает, только если на вашей машине сервисы не переведены под управление в skycore. Для переведенных сервисов мы реализуем новый, более удобный способ, но пока этого нет.

{% endnote %}

Сейчас на машины по умолчанию приезжает ограниченный набор сервисов (super stable skynet):
- procman
- logger
- heartbeat-client
- copier

1. Если вам вдруг необходим какой-то дополнительный сервис, например **cqudp для работы Самогона**, тогда обратитесь с этим вопросом к вашим SRE или в рассылку skynet@yandex-team.ru.
1. Если же у вас есть на машине **sudo** и более того это виртуалка в **OpenStack**, тогда существует альтернативный способ (работает, начиная со skynet v15.18.13):
   - по пути **/Berkanavt/supervisor/etc/registry/conf.d** положить файлик в формате **yaml** (*вместо Berkanavt может быть /opt/skynet или что-то другое*);
   - если папка conf.d отсутствует, то ее надо создать;
   - содержимое файла, на примере сервиса cqudp, такое (skynet.cqudp_enabled.yaml):
          
      
      ```
      
      data:
        skynet.base:
          data:
            v1:
              services:
                enabled:
                  cqudp: true
      
        skynet.services.cqudp:
          data:
            service:
              enabled: true
          
      ```
   - для других отсутствующих сервисов можно создать другие файлы по аналогии, просто заменив название сервиса в двух местах и положив их в ту же папку.
   
     {% note alert %}

     Не забудьте переустановить skynet:

     ```
     sudo /Berkanavt/skynet/bin/gosky --force-update
     ```

     {% endnote %}

{% endcut %}

