import os
from kernel.util.functional import memoized
from kernel.util.sys.dirut import ensureDirs
from api.srvmngr import getRoot


__all__ = ['getSocketPath']


@memoized
def getSocketPath(name, makeDirs=False):
    socketDir = os.path.join(getRoot(), 'var')
    if makeDirs:
        ensureDirs(socketDir)
    return os.path.join(socketDir, "%s.sock" % name)
