from collections import MutableMapping
from .cistr import CIStr

import unittest


class CIDict(MutableMapping):
    """
    Case insensitive dict.
    """
    def __init__(self, *args, **kwargs):
        self._dict = {}
        self.update(dict(*args, **kwargs))

    def __setitem__(self, key, value):
        self._dict[CIStr(key)] = value

    def __getitem__(self, key):
        return self._dict[CIStr(key)]

    def __delitem__(self, key):
        del self._dict[CIStr(key)]

    def __iter__(self):
        return iter(self._dict)

    def __len__(self):
        return len(self._dict)

    def has_key(self, key):
        return CIStr(key) in self._dict


class TestCIDict(unittest.TestCase):
    def testSet(self):
        d = CIDict()
        d["AbC"] = 1
        self.assertEqual(d["abc"], 1)

    def testSetDefault(self):
        d = CIDict()
        d.setdefault("AbC", []).append(1)
        self.assertEqual(d["abc"], [1])

    def testUpdate(self):
        d = CIDict()
        d["AbC"] = 3
        d["BbB"] = 2
        d.update({"Abc": 4, "DdD": 5})
        self.assertEqual(d["aBc"], 4)
        self.assertEqual(len(d), 3)
