from __future__ import absolute_import

import os
import sys

from .setproctitle import setProcTitle  # noqa
from .colors import *  # noqa


__defaultTerminalSize = (25, 80)

if os.name == "posix":
    import termios
    import fcntl
    import struct

    def isTerminal(fd=None):
        """
        Returns whether fd is a tty device
        """
        if fd is None:
            try:
                fd = sys.stdout.fileno()
            except (AttributeError, ValueError):  # stdout was replaced by some non-file object
                return False

        try:
            termios.tcgetattr(fd)
            return True
        except termios.error:
            return False

    def getUserAttention():
        """
        Produces bell
        """
        if not isTerminal():
            return
        sys.stdout.write("\x07")
        sys.stdout.flush()

    def setTerminalTitle(title):
        """
        Sets title for current terminal
        """
        if not isTerminal():
            return
        sys.stdout.write("\x1b]0;" + title + "\x07")
        sys.stdout.flush()

    def getTerminalSize():
        if not isTerminal():
            return __defaultTerminalSize

        try:
            ts = struct.unpack('hh', fcntl.ioctl(1, termios.TIOCGWINSZ, '1234'))
            return int(ts[1]), int(ts[0])
        except:
            return __defaultTerminalSize

else:
    def isTerminal(fd=None):
        return False

    def getUserAttention():
        pass

    def setTerminalTitle(title):
        pass

    def getTerminalSize():
        return __defaultTerminalSize
