# we need this because there are separate package 'setproctitle'
# see http://code.google.com/p/py-setproctitle/
from __future__ import absolute_import
import os
import sys


def setProcTitle(s):
    # We need this func, which will load anything on-demand because we import this
    # module during kernel.util.console imports and setproctitle package changes
    # cmd (even argv) during load, because it need to initialize ps strings.
    # So if some user does not even want to use setproctitle, but imports kernel.util.console
    # we dont want his program to suddenly change cmd line. See SKYNET-39.

    try:
        # First try to import global setproctitle
        from setproctitle import setproctitle
        return setproctitle(s)
    except ImportError:
        if os.name == 'posix' and sys.platform != 'cygwin':
            # Next, try to import libc() version but only for posix platform
            from kernel.util.sys import libc

            try:
                return libc().setproctitle('-%s', str(s))
            except AttributeError:
                pass
        else:
            # For non-posix we have no way to change proc title atm :-/
            return
