from __future__ import absolute_import

import sys


def monkeyPatchGevent(Greenlet=None):
    """
    Should be called to install new default Greenlet class
    :param Greenlet: Class of greenlet to install
    """
    if Greenlet is None:
        from .greenlet import Greenlet
    from .greenlet import makeGreenletContextAware
    import gevent
    import gevent.greenlet  # noqa
    sys.modules['gevent'].Greenlet = Greenlet
    sys.modules['gevent'].spawn = Greenlet.spawn
    sys.modules['gevent'].spawn_later = Greenlet.spawn_later
    sys.modules['gevent'].spawn_link = Greenlet.spawn_link
    sys.modules['gevent'].spawn_link_value = Greenlet.spawn_link_value
    sys.modules['gevent'].spawn_link_exception = Greenlet.spawn_link_exception
    sys.modules['gevent.greenlet'].Greenlet = Greenlet
    sys.modules['gevent.greenlet'].Greenlet.spawn = Greenlet.spawn
    sys.modules['gevent.greenlet'].Greenlet.spawn_later = Greenlet.spawn_later
    sys.modules['gevent.greenlet'].Greenlet.spawn_link = Greenlet.spawn_link
    sys.modules['gevent.greenlet'].Greenlet.spawn_link_value = Greenlet.spawn_link_value
    sys.modules['gevent.greenlet'].Greenlet.spawn_link_exception = Greenlet.spawn_link_exception
    makeGreenletContextAware()
