# Deprecated
import sys

from ..console import isTerminal
from ..sys import rotateFile

from .log import Log

__all__ = [
    "LogInstaller",
    "gLogInstaller"
]

gLogInstaller = None


class LogInstaller:
    def __init__(self, fileName=None, logInfo=False, logDebug=False, logProto=False, rotateAtMidnight=False):
        global gLogInstaller
        self.fileName = fileName
        self.logInfo = logInfo
        self.logProto = logProto
        self.logDebug = logDebug
        self.rotateAtMidnight = rotateAtMidnight
        self.writers = []
        if gLogInstaller:
            gLogInstaller.uninstall()
        gLogInstaller = self

    def __call__(self):
        self.install()

    def __enter__(self):
        self.uninstall()
        self.install()
        return self

    def __exit__(self, exc_type, exc_value, traceback):
        self.uninstall()

    def install(self):
        file = None
        if self.fileName:
            try:
                file = open(self.fileName, "a+")
            except IOError:
                pass

        if not file:
            file = sys.stderr, sys.stdout
            if isTerminal():
                formats = Log.colorLogFormat.copy()
            else:
                formats = Log.defaultLogFormats.copy()
        else:
            formats = Log.defaultLogFormats.copy()

        if isinstance(file, tuple):
            infoFormat = formats.pop(Log.Levels.info)
            protoFormat = formats.pop(Log.Levels.proto)
            debugFormat = formats.pop(Log.Levels.debug)

            Log.addWriter(file[0], formats)
            self.writers.append(file[0])
            formats1 = {}
            if self.logInfo:
                formats1[Log.Levels.info] = infoFormat
            if self.logProto:
                formats1[Log.Levels.proto] = protoFormat
            if self.logDebug:
                formats1[Log.Levels.debug] = debugFormat
            if formats1:
                Log.addWriter(file[1], formats1)
                self.writers.append(file[1])
        else:
            if not self.logInfo:
                formats.pop(Log.Levels.info)
            if not self.logProto:
                formats.pop(Log.Levels.proto)
            if not self.logDebug:
                formats.pop(Log.Levels.debug)
            Log.addWriter(file, formats)
            self.writers.append(file)

    def uninstall(self):
        for writer in self.writers:
            Log.removeWriter(writer)
            try:
                writer.close()
            except IOError:
                pass
        self.writers = []

    def rotate(self):
        self.uninstall()
        if self.fileName:
            rotateFile(self.fileName)

        self.install()
