import six
import datetime


__cachedMemberName__ = "cached__%s"


def clearCachingMethod(method):
    if hasattr(method.__self__, __cachedMemberName__ % method.__name__):
        delattr(method.__self__, __cachedMemberName__ % method.__name__)


def cachingMethod(method):
    def cachingMethod(self, subMethod=method, cachedMemberName=__cachedMemberName__ % method.__name__):
        if hasattr(self, cachedMemberName):
            return getattr(self, cachedMemberName)
        else:
            result = subMethod(self)
            setattr(self, cachedMemberName, result)
            return result
    cachingMethod.__name__ = method.__name__
    return cachingMethod


def clearCachingFunction(function):
    if hasattr(function, __cachedMemberName__ % "result"):
        delattr(function, __cachedMemberName__ % "result")


def cachingFunction(function):
    def cachingFunction(function=function, cachedMemberName=__cachedMemberName__ % "result"):
        if hasattr(function, cachedMemberName):
            return getattr(function, cachedMemberName)
        else:
            result = function()
            setattr(function, cachedMemberName, result)
            return result
    return cachingFunction


def intFromStr(str):
    i = len(str) - 1
    result = 0
    while i >= 0:
        result *= 256
        result += ord(str[i])
        i -= 1
    return result


def intToStr(digit, ln=None):
    i = 0
    result = ""
    while digit > 0 and ((ln is None) or (i < ln)):
        result += chr(digit % 256)
        digit /= 256
        i += 1
    while (ln is not None) and (i < ln):
        result += chr(0)
        i += 1
    return result


def daemonthr(target, *args, **kwargs):
    from threading import Thread
    name = kwargs.pop('__name', None)
    should_start = kwargs.pop('__start', True)
    if name is None:
        name = 'DaemonThread {}'.format(target)
    t = Thread(target=target, name=name, args=args, kwargs=kwargs)
    t.daemon = True
    if should_start:
        t.start()
    return t


def safeOpen(path, mode):
    try:
        return open(path, mode)
    except:
        import os

        try:
            os.makedirs(os.path.dirname(path))
        except:
            pass

    return open(path, mode)


# Size to string formatter
def size2str(size):
    size = float(size)
    mods = ['byte(s)'] + ['%siB' % c for c in 'KMGTPEZY']
    for mod in mods:
        if abs(size) < 0x400 or mod == mods[-1]:
            return '%.2f%s' % (size, mod)
        size /= 0x400


# Datetime to string formatter
dt2str = lambda x: 'None' if x is None else x.strftime('%Y-%m-%d %H:%M:%S')


# Timestamp to string formatter
ts2str = lambda x: 'None' if x is None else datetime.datetime.fromtimestamp(x).strftime('%Y-%m-%d %H:%M:%S')


# Timedelta to string formatter
def td2str(delta, full=False):
    if isinstance(delta, (float,) + six.integer_types):
        delta = datetime.timedelta(seconds=delta)
    hrs, secs = divmod(delta.seconds, 3600)
    mins, secs = divmod(secs, 60)
    ret = ''

    suffixes = list('dhms') if not full else [' %s(s)' % x for x in 'day hour minute second'.split()]
    for fmt, val in zip(suffixes, (delta.days, hrs, mins, secs)):
        if val or ((ret or fmt == 's') and not full):
            ret += '{0:s}{1:0>2d}{2:s}'.format(' ' if ret else '', val, fmt)
    return ret

# Timedelta to seconds formatter (needed till Python 2.7 upgrade).
td2s = lambda x: x.seconds + x.days * 86400
