import six
from threading import Thread
import traceback

Queue = six.moves.queue.Queue
QueueEmpty = six.moves.queue.Empty


class imtmap:
    class smartPolicy:
        pass

    class allThread:
        pass

    class singleThread:
        pass

    def __init__(self, functor, iterable, policy=smartPolicy):
        self.functor = functor
        self.it = iter(iterable)
        self.puted = 0
        self.yielded = 0
        self.requestQueue = Queue()
        self.responseQueue = Queue()
        self.spawnedThread = 0
        self.policy = policy

    def doPutRequests(self, needPuted=1):
        try:
            while True:
                request = self.it.next()
                self.requestQueue.put(request)
                self.puted += 1
                if needPuted <= self.puted:
                    break
        except StopIteration:
            return False
        return True

    def threadMain(self):
        try:
            while True:
                request = self.requestQueue.get()
                if request is None:
                    return
                try:
                    self.responseQueue.put((self.functor(request), None))
                except BaseException as err:
                    err.traceback = traceback.format_exc()
                    self.responseQueue.put((None, err))
                    return
                finally:
                    self.requestQueue.task_done()
        except:
            pass

    def spawnThreads(self, amount=1):
        for _i in six.moves.xrange(amount):
            thread = Thread(target=self.threadMain, name="iMtMap {0}".format(self.spawnedThread))
            thread.daemon = True
            thread.start()
            self.spawnedThread += 1

    def singleIter(self):
        for request in self.it:
            yield self.functor(request)

    def allIter(self):
        self.spawnThreads()
        while self.doPutRequests():
            try:
                response = self.responseQueue.get(block=False)
                if not response[1]:
                    yield response[0]
                    self.yielded += 1
                else:
                    raise response[1]
            except QueueEmpty:
                self.spawnThreads()
        while self.puted > self.yielded:
            response = self.responseQueue.get()
            if not response[1]:
                yield response[0]
                self.yielded += 1
            else:
                raise response[1]

    def smartIter(self):
        atEnd = not self.doPutRequests(5)
        self.spawnThreads(2)

        while (not atEnd) or self.yielded < self.puted:
            response = self.responseQueue.get()
            if not response[1]:
                yield response[0]
            else:
                raise response[1]

            self.yielded += 1

            if (self.puted - self.yielded) <= (self.puted / 3):
                atEnd = not self.doPutRequests(self.puted + (self.puted / 3))

            if 100 * self.spawnedThread < self.puted and self.spawnedThread < 100:
                self.spawnThreads()

        for _i in six.moves.xrange(self.spawnedThread):
            self.requestQueue.put(None)

    def __iter__(self):
        if self.policy is self.smartPolicy:
            return self.smartIter()
        elif self.policy is self.singleThread:
            return self.singleIter()
        elif self.policy is self.allThread:
            return self.allIter()
