import os

from ..streams.streambase import StreamBase
from .pipe import Pipe


class PipeStream(Pipe, StreamBase):
    def __init__(self, r=None, w=None):
        Pipe.__init__(self, r, w)
        StreamBase.__init__(self, self)

    write = Pipe.writeAll
    read = Pipe.readExact


def createPipeStream():
    r1, w1 = os.pipe()
    r2, w2 = os.pipe()
    return PipeStream(r1, w2), PipeStream(r2, w1)
