import os
import socket


if os.name == "posix":
    def socketPair(family=socket.AF_UNIX, type=socket.SOCK_STREAM, protocol=socket.IPPROTO_IP, socketModule=socket):
        return socketModule.socketpair(family, type, protocol)
else:
    def _waitConnect(sock, port):
        sock.connect(('localhost', port))

    def socketPair(family=socket.AF_INET, type=socket.SOCK_STREAM, protocol=socket.IPPROTO_IP, socketModule=socket):

        listenSock = socketModule.socket(family, type, protocol)

        listenSock.setsockopt(socket.SOL_SOCKET, socket.SO_REUSEADDR, 1)
        listenSock.bind(('localhost', 0))
        port = listenSock.getsockname()[1]
        listenSock.listen(1)
        sock1 = socketModule.socket(family, type, protocol)
        if socketModule.__name__ == 'gevent.socket':
            import gevent
            connThread = gevent.Greenlet(_waitConnect, sock1, port)
        else:
            import threading
            connThread = threading.Thread(target=_waitConnect, args=[sock1, port])
            connThread.setDaemon(1)

        connThread.start()
        sock2 = listenSock.accept()[0]
        listenSock.close()
        return sock1, sock2
