import socket

from kernel.util.unittest import TestCase, main
from kernel.util.net.getifaddrs import getIfAddrs


class TestGetIfAddrs(TestCase):
    def testSimple(self):
        addrs = getIfAddrs()
        self.assertTrue('lo' in addrs)
        lo = addrs['lo']
        for addr in lo:
            if addr.family == socket.AF_INET:
                self.assertEqual(addr.addr, "127.0.0.1")
            if addr.family == socket.AF_INET6:
                self.assertEqual(addr.addr, "::1")

if __name__ == '__main__':
    main()
