import socket

from kernel.util.unittest import TestCase, main
from kernel.util.net.misc import packIP, unpackIP, getFreePort


class TestPackUnpack(TestCase):
    def testPack(self):
        self.assertEqual(packIP("127.0.0.1"), 2130706433)
        self.assertEqual(packIP("0.0.0.1"), 1)
        self.assertEqual(packIP("::1", socket.AF_INET6), 1)

    def testUnpack(self):
        self.assertEqual("127.0.0.1", unpackIP(2130706433))
        self.assertEqual("0.0.0.1", unpackIP(1))
        self.assertEqual("::1", unpackIP(1, socket.AF_INET6))

    def testPackUnpack(self):
        from random import randrange
        for i in range(20):
            r = randrange(1 << 32)
            self.assertEqual(r, packIP(unpackIP(r)))
            r = randrange(1 << 128)
            self.assertEqual(r, packIP(unpackIP(r, socket.AF_INET6), socket.AF_INET6))


class TestFreePort(TestCase):
    def testFreePort(self):
        self.assertTrue(getFreePort())

if __name__ == '__main__':
    main()
