import operator


class ObjProxy(object):
    """
    Proxy which behaves as underlying object.
    """
    def __init__(self, obj):
        self.__dict__['obj'] = obj

    def __abs__(self):
        return abs(self.obj)

    def __add__(self, y):
        return self.obj + y

    def __and__(self, y):
        return self.obj & y

    def __cmp__(self, y):
        return cmp(self.obj, y)  # noqa

    def __contains__(self, y):
        return y in self.obj

    def __delattr__(self, name):
        delattr(self.obj, name)

    def __delitem__(self, y):
        del self.obj[y]

    def __delslice__(self, i, j):
        del self.obj[i:j]

    def __divmod__(self, y):
        return divmod(self.obj, y)

    def __div__(self, y):
        return self.obj / y

    def __float__(self):
        return float(self.obj)

    def __floordiv__(self, y):
        return self.obj // y

    def __getattr__(self, item):
        return getattr(self.obj, item)
    # def __getattribute__(self, name):

    def __getitem__(self, y):
        return self.obj[y]

    def __getslice__(self, i, j):
        return self.obj[i:j]

    def __iadd__(self, y):
        self.obj += y

    def __iand__(self, y):
        self.obj &= y

    def __idiv__(self, y):
        self.obj /= y

    def __ifloordiv__(self, y):
        self.obj //= y

    def __ilshift__(self, y):
        self.obj <<= y

    def __imod__(self, y):
        self.obj %= y

    def __imul__(self, y):
        self.obj *= y

    def __index__(self):
        return operator.index(self.obj)

    def __int__(self):
        return int(self.obj)

    def __invert__(self):
        return ~self.obj

    def __ior__(self, y):
        self.obj |= y

    def __ipow__(self, y):
        self.obj **= y

    def __irshift__(self, y):
        self.obj >>= y

    def __isub__(self, y):
        self.obj -= y

    def __iter__(self):
        return iter(self.obj)

    def __itruediv__(self, y):
        operator.itruediv(self.obj, y)

    def __ixor__(self, y):
        self.obj ^= y

    def __len__(self):
        return len(self.obj)

    def __long__(self):
        return long(self.obj)  # noqa

    def __lshift__(self, y):
        return self.obj << y

    def __mod__(self, y):
        return self.obj % y

    def __mul__(self, y):
        return self.obj * y

    def __neg__(self):
        return -self.obj

    def __nonzero__(self):
        return bool(self.obj)

    def __bool__(self):
        return bool(self.obj)

    def __or__(self, y):
        return self.obj | y

    def __pos__(self):
        return +self.obj

    def __pow__(self, y, z=None):
        return pow(self.obj, y, z)

    def __radd__(self, y):
        return y + self.obj

    def __rand__(self, y):
        return y & self.obj

    def __rdivmod__(self, y):
        return divmod(y, self.obj)

    def __rdiv__(self, y):
        return y / self.obj

    def __repr__(self):
        return repr(self.obj)

    def __rfloordiv__(self, y):
        return y // self.obj

    def __rlshift__(self, y):
        return y << self.obj

    def __rmod__(self, y):
        return y % self.obj

    def __rmul__(self, y):
        return y * self.obj

    def __ror__(self, y):
        return y | self.obj

    def __rpow__(self, x, z=None):
        return pow(x, self.obj, z)

    def __rrshift__(self, y):
        return y >> self.obj

    def __rshift__(self, y):
        return self.obj >> y

    def __rsub__(self, y):
        return y - self.obj

    def __rtruediv__(self, y):
        return operator.truediv(y, self.obj)

    def __rxor__(self, y):
        return y ^ self.obj

    def __setattr__(self, name, value):
        setattr(self.obj, name, value)

    def __setitem__(self, i, y):
        self.obj[i] = y

    def __setslice__(self, i, j, y):
        self.obj[i:j] = y

    def __str__(self):
        return str(self.obj)

    def __sub__(self, y):
        return self.obj - y

    def __truediv__(self, y):
        return operator.truediv(self.obj, y)

    def __unicode__(self):
        return unicode(self)  # noqa

    def __xor__(self, y):
        return self.obj ^ y
