import os


class Priorities(object):
    """
    Available canonical priorities
    """
    Idle = 0
    Low = 1
    BelowNormal = 2
    Normal = 3
    AboveNormal = 4
    High = 5
    RealTime = 6

# Meaning for process
if os.name != 'posix':
    import win32process
    ProcessPriorities = {
        Priorities.Idle: win32process.IDLE_PRIORITY_CLASS,
        Priorities.Low: win32process.IDLE_PRIORITY_CLASS,
        Priorities.BelowNormal: win32process.BELOW_NORMAL_PRIORITY_CLASS,
        Priorities.Normal: win32process.NORMAL_PRIORITY_CLASS,
        Priorities.AboveNormal: win32process.ABOVE_NORMAL_PRIORITY_CLASS,
        Priorities.High: win32process.HIGH_PRIORITY_CLASS,
        Priorities.RealTime: win32process.REALTIME_PRIORITY_CLASS
    }
else:
    ProcessPriorities = {
        Priorities.Idle: 20,
        Priorities.Low: 10,
        Priorities.BelowNormal: 5,
        Priorities.Normal: 0,
        Priorities.AboveNormal: -5,
        Priorities.High: -10,
        Priorities.RealTime: -15
    }

# Meanings for traffic are subject to change and approximate:
#    - Idle - secondary network only, lowered QOS, lowered internal
#    - Low - secondary network only, lowered QOS, lowered internal
#    - Below normal - secondary network only, normal QOS, normal internal
#    From that point secondary network are temporary disabled (Unless fastbone fixed everywhere)
#    - Normal - secondary or primary network, normal QOS in secondary lowered in primary, normal internal
#    - Above normal - secondary or primary network, normal QOS, normal internal
#    - High - primary network only, normal QOS, raised internal
#    - RealTime - primary network only, normal QOS, highest internal
