import os


if os.name == "posix":
    envSeparator = ":"
else:
    envSeparator = ";"


def resolveExecutablePath(executable):
    """Resolves path to executable acording to PATH env"""
    path = os.getenv("PATH").split(envSeparator)
    for dir in path:
        if os.access(os.path.join(dir, executable), os.X_OK):
            return os.path.join(dir, executable)
    return None
