from __future__ import absolute_import

import sys


class TestBrickMeta(type):
    def __new__(self, name, bases, dict):
        newtype = type.__new__(self, name, bases, dict)

        if '__metaclass__' not in dict and type(bases[0]) != object:
            newtypeInstance = newtype()
            newtypeModule = dict['__module__']  # module there our object defined

            # use either provided name from brick class, either class name with lowered first letter
            brickName = dict.get('name') or ''.join((name[0].lower(), name[1:]))
            funcargName = 'pytest_funcarg__%s' % brickName

            # avoid name clashing
            if hasattr(sys.modules[newtypeModule], funcargName):
                try:
                    from py.test.collect import Collector
                    CollectError = Collector.CollectError
                except ImportError:
                    CollectError = Exception
                raise CollectError('Two bricks in one module with same name %r!' % brickName)

            def __funcarg_proxy(request):
                return self.funcargProxy(newtypeInstance, request)
            __funcarg_proxy.__doc__ = '[' + dict['__module__'] + '.' + name + ']\n'
            if '__doc__' in dict:
                __funcarg_proxy.__doc__ += dict['__doc__'].strip() + '\n'

            setattr(
                sys.modules[newtypeModule],  # module there our brick defined
                funcargName,                 # pytest funcarg
                __funcarg_proxy              # funcargProxy with new brick instance
            )

            optionsFuncs = getattr(sys.modules[newtypeModule], '_optionsFuncs', [])
            optionsFuncs.append(newtypeInstance.options)

            if not hasattr(sys.modules[newtypeModule], 'pytest_addoption'):
                setattr(sys.modules[newtypeModule], '_optionsFuncs', optionsFuncs)
                setattr(
                    sys.modules[newtypeModule],
                    'pytest_addoption',
                    lambda parser: self.optionsProxy(optionsFuncs, parser)
                )

            # little note about ^above^: we are not using 'curry' pattern for
            # funcargProxy, because we dont want test infrastructure depend
            # on test object (skynet ;)).

        return newtype

    @staticmethod
    def funcargProxy(brick, request):
        return request.cached_setup(
            setup=lambda *args, **kwargs: brick.setUp(request, *args, **kwargs),
            teardown=lambda *args, **kwargs: brick.tearDown(request, *args, **kwargs),
            scope=brick.scope
        )

    @staticmethod
    def optionsProxy(funcs, parser):
        for func in funcs:
            func(parser)


class TestBrick(object):
    __metaclass__ = TestBrickMeta

    name = None         # brick name, will be myBrick for MyBrick class if not specified
    scope = 'function'  # good values are 'test', 'session' and 'module'

    def setUp(self, request):
        pass

    def tearDown(self, *args, **kwargs):
        pass

    def options(self, parser):
        pass
