import zlib

__all__ = [
    "ZStream"
]


class ZStream:
    def __init__(self, slave):
        self.slave = slave
        self.comp = None
        self.deComp = None
        self.buff = ""
        self.buffOff = 0

    def __enter__(self):
        return self

    def __exit__(self, _excType, _excValue, _traceback):
        self.close()

    def close(self):
        if self.comp:
            self.slave.write(self.comp.flush())

    def write(self, data):
        if not self.comp:
            self.comp = zlib.compressobj()
        self.slave.write(self.comp.compress(data))

    def readBuf(self, toRead):
        if toRead > len(self.buff) - self.buffOff:
            return self.read(toRead)
        result = buffer(self.buff, self.buffOff, toRead)  # noqa
        self.buffOff += toRead
        return result

    def read(self, toRead):
        if not self.deComp:
            self.deComp = zlib.decompressobj()
        while toRead > len(self.buff) - self.buffOff:
            data = self.slave.read(max(toRead - len(self.buff) + self.buffOff, 10 * 1024))
            if not data:
                result = self.buff if not self.buffOff else self.buff[self.buffOff:]
                self.buff = ""
                self.buffOff = 0
                return result
            self.buff += self.deComp.decompress(data)
        result = self.buff[self.buffOff:self.buffOff + toRead]
        self.buff = self.buff[self.buffOff + toRead:]
        self.buffOff = 0
        return result

    def flush(self):
        if self.comp:
            self.slave.write(self.comp.flush(zlib.Z_SYNC_FLUSH))
