"""
As atexit module with following differences:
   1. unregister function
   2. exception traces to log
"""
from __future__ import absolute_import

__author__ = 'kaliki'

import atexit
import six

from .. import logging
from ..functional import singleton


__all__ = ['register', 'unregister']

log = logging.getLogger('ya.skynet.util.atexit')


class ExitHandler(object):
    def __init__(self):
        self.__handlers = {}
        atexit.register(self.__handleExit)

    def register(self, callback, args, kwargs):
        assert six.callable(callback), 'Callback must be callable'
        self.__handlers[callback] = (args, kwargs)

    def unregister(self, callback):
        self.__handlers.pop(callback, None)

    def __handleExit(self):
        for callback, args in list(self.__handlers.items()):
            try:
                callback(*args[0], **args[1])
            except Exception as err:
                log.exception(str(err))


@singleton
def exitHandler():
    return ExitHandler()


def register(callback, *args, **kwargs):
    exitHandler().register(callback, args, kwargs)


def unregister(callback):
    exitHandler().unregister(callback)
