import os
import sys

if os.name == 'posix':
    try:
        import resource
    except ImportError:
        resource = None

    def demonize(umask=0, pwd=None):
        if resource:
            max_fd = resource.getrlimit(resource.RLIMIT_NOFILE)[1]
            if max_fd == resource.RLIM_INFINITY:
                max_fd = 1024
        else:
            max_fd = 1024

        if hasattr(os, "devnull"):
            devnull = os.devnull
        else:
            devnull = "/dev/null"

        try:
            pid = os.fork()
        except OSError:
            return False

        if pid:
            # If parent needs to continue after daemonization
            # it shuld catch SystemExit exception from here.
            sys.exit(0)

        os.setsid()

        try:
            pid = os.fork()
        except OSError:
            return False

        if pid:
            os._exit(0)

        if pwd:
            os.chdir(pwd)

        os.umask(umask)

        os.closerange(0, max_fd)

        os.open(devnull, os.O_RDWR)  # Should return 0
        os.dup2(0, 1)
        os.dup2(0, 2)

        return True
else:
    def demonize(umask=0, pwd=None):
        if pwd:
            os.chdir(pwd)
        os.umask(umask)
        return True
