from sys import platform

__all__ = [
    'getpeerid'
]

if platform.startswith('freebsd'):
    from .freebsd import getpeerid
elif platform.startswith('linux'):
    from .linux import getpeerid
elif platform.startswith('darwin'):
    from .darwin import getpeerid
elif platform.startswith('cygwin'):
    from .linux import getpeerid
else:
    def getpeerid(sock):
        raise NotImplementedError("no getpeerid function: platform={0}".format(platform))
