import os


def nCpu():
    if hasattr(os, "sysconf"):
        if "SC_NPROCESSORS_ONLN" in os.sysconf_names:
            nCpu = os.sysconf("SC_NPROCESSORS_ONLN")
            if isinstance(nCpu, int) and nCpu > 0:
                return nCpu
        else:
            return int(os.popen2("sysctl -n hw.ncpu")[1].read())
    if "NUMBER_OF_PROCESSORS" in os.environ:
        nCpu = int(os.environ["NUMBER_OF_PROCESSORS"])
        if nCpu > 0:
            return nCpu
    return 1
