import os


def _get_ns(pid, ns):
    path = os.path.join('/proc/', str(pid), 'ns', ns)
    if os.path.exists(path):
        return os.readlink(path)


def same_container(pid, files=True, procs=True):
    selfpid = os.getpid()

    if files:
        self_mnt_ns = _get_ns(selfpid, 'mnt')
        oth_mnt_ns = _get_ns(pid, 'mnt')
    else:
        self_mnt_ns = oth_mnt_ns = None

    if procs:
        self_pid_ns = _get_ns(selfpid, 'pid')
        oth_pid_ns = _get_ns(pid, 'pid')
    else:
        self_pid_ns = oth_pid_ns = None

    if self_mnt_ns != oth_mnt_ns or self_pid_ns != oth_pid_ns:
        return False

    return True
