import sys
import os
import ctypes
import ctypes.util

from ..functional import singleton


def getLib(libNames, useErrNo=False):
    result = None
    for name in libNames:
        try:
            result = ctypes.CDLL(name, use_errno=useErrNo)
        except EnvironmentError:
            continue
    if result is None:
        raise EnvironmentError("Cant find lib {0}".format(", ".join(libNames)))
    return result


@singleton
def libc(useErrNo=False):
    if getattr(sys, 'is_standalone_binary', False):
        return ctypes.CDLL(ctypes.util.find_library('c'), use_errno=useErrNo)

    if sys.platform == 'darwin':
        return getLib(['libSystem.dylib', 'libSystem.B.dylib'], useErrNo)
    elif sys.platform == 'cygwin':
        return getLib(['cygwin.dll', 'cygwin1.dll'], useErrNo)
    return getLib(['libc.so', 'libc.so.6'], useErrNo)


@singleton
def librt(useErrNo=False):
    if getattr(sys, 'is_standalone_binary', False):
        return libc(useErrNo)

    if os.uname()[0].lower() == "freebsd":
        return libc(useErrNo)
    return getLib(["librt.so", "librt.so.1"], useErrNo)
