import os
import threading
import thread  # noqa

from kernel.util.sys.aio import aioRead
from kernel.util.unittest import TestCase, main
from kernel.util.sys.dirut import TempDir

import six


class testAio(TestCase):
    def testAio(self):
        sem = threading.Semaphore()

        data = ''.join([chr(i % 256) * 1024 for i in six.moves.xrange(200 * 1024)])

        with TempDir() as wd:
            fileName = os.path.join(wd, 'testfile')

            with open(fileName, 'w+') as f:
                f.seek(0)
                f.write(data)

            rng = (100, 1100)

            def cb(buf, err):
                try:
                    assert buf == data[rng[0]:rng[1]]
                    sem.release()
                except Exception:
                    raise SystemExit()

            sem.acquire()
            aioRead(fileName, rng[0], rng[1] - rng[0], cb)
            sem.acquire()

if __name__ == '__main__':
    main()
