"""
Test getpeerid function.
"""

import os

import socket
import gevent
import gevent.socket

from kernel.util import unittest
from kernel.util.sys.getpeerid import getpeerid
from kernel.util.sys.dirut import TempDir


class TestGetPeerId(unittest.TestCase):
    def test_pipe(self):
        pipe = os.pipe()
        try:
            self.assertRaises(EnvironmentError, getpeerid, pipe[0])
        finally:
            os.close(pipe[0])
            os.close(pipe[1])

    def test_inet_socket(self):
        s = socket.socket()
        self.assertRaises(EnvironmentError, getpeerid, s)

    # don't want to mess with threads here
    # so don't run without gevent
    def test_ok_socket(self):
        # get uid
        uid = os.getuid()
        with TempDir() as temp:
            sock_path = os.path.join(temp, 'test.socket')

            server = gevent.socket.socket(socket.AF_UNIX, socket.SOCK_STREAM)

            if os.path.exists(sock_path):
                os.remove(sock_path)

            server.bind(sock_path)
            c = None
            try:
                server.listen(1)
                # client setup
                client = gevent.socket.socket(socket.AF_UNIX, socket.SOCK_STREAM)
                gevent.spawn(client.connect, sock_path)

                c, addr = server.accept()

                peeruid = getpeerid(c)[0]
                self.assertIsInstance(peeruid, int)
                self.assertEqual(peeruid, uid)
            finally:
                if c:
                    c.close()
                server.close()

if __name__ == '__main__':
    unittest.main()
