from __future__ import print_function
import os
import select

from kernel.util.unittest import TestCase, main
from kernel.util.sys.pipenblock import pipeNBlock


class PipeNBlockTest(TestCase):
    def test(self):
        pipe = pipeNBlock()
        rr, rw, _re = select.select([pipe[0]], [pipe[1]], [], 0)
        self.assertFalse(rr)
        self.assertTrue(rw)
        data = "akjdalkdjalkdajdakdas" * 1024 * 1024
        try:
            written = os.write(pipe[1], data)
            os.write(pipe[1], data)
        except (OSError, IOError) as e:
            self.assertTrue(len(e.args) >= 1 and e.args[0] == os.errno.EAGAIN)
            print(e, os.errno.EAGAIN, os.errno.EWOULDBLOCK)
        except BaseException as e:
            self.fail(str(e))
        else:
            rr, rw, _re = select.select([pipe[0]], [pipe[1]], [], 0)
            self.assertTrue(rr)
            self.assertFalse(rw)
            self.assertTrue(written < len(data))


if __name__ == "__main__":
    main()
