import resource
import subprocess


def getUserResourceLimits(user, umask=False, defaults=None):
    data = subprocess.Popen(['/bin/launchctl', 'limit'],
                            stdout=subprocess.PIPE,
                            stderr=subprocess.PIPE,
                            close_fds=True).communicate()[0]
    limits = {} if defaults is None else defaults
    known = {
        'cpu': resource.RLIMIT_CPU,
        'filesize': resource.RLIMIT_FSIZE,
        'data': resource.RLIMIT_DATA,
        'stack': resource.RLIMIT_STACK,
        'core': resource.RLIMIT_CORE,
        'rss': resource.RLIMIT_RSS,
        'memlock': resource.RLIMIT_MEMLOCK,
        'maxproc': resource.RLIMIT_NPROC,
        'maxfiles': resource.RLIMIT_NOFILE,
    }

    for line in data.split('\n'):
        line = line.strip()
        if not line:
            continue
        line = line.split()
        if len(line) != 3:
            continue
        limname = known.get(line[0])
        if limname is None:
            continue
        try:
            limits[limname] = (
                resource.RLIM_INFINITY if line[1] == 'unlimited' else int(line[1]),
                resource.RLIM_INFINITY if line[2] == 'unlimited' else int(line[2])
            )
        except ValueError:
            continue

    return (limits, 0o022) if umask else limits
