import os
try:
    import _winreg as winreg
except ImportError:
    import winreg

import win32security


__all__ = [
    'getUserName',
    'getUserHome',
    'getUserUID',
    'getUserGIDs',
    'getResourceLimits',
    'setResourceLimits',
    'getUserResourceLimits',
    'UserPrivileges',
    'userPrivileges',
]


def getUserName():
    return os.getenv("USERNAME")


def getUserHome(username=None):
    if username is None:
        return os.getenv("HOMEDRIVE") + os.getenv("HOMEPATH")
    # TODO: check on real windows machine
    sid = win32security.LookupAccountName(None, username)[0]
    sid = win32security.ConvertSidToStringSid(sid)
    key = winreg.OpenKey(winreg.HKEY_LOCAL_MACHINE, r"SOFTWARE\Microsoft\Windows NT\CurrentVersion\ProfileList" + "\\" + sid)
    value, _type = winreg.QueryValueEx(key, "ProfileImagePath")
    return value


def getUserUID(user=None):
    return None


def getUserGIDs(user=None):
    return []


def getResourceLimits():
    return {}


def setResourceLimits(limits, minimalLimits=None):
    return


def getUserResourceLimits(user, umask=False, defaults=None):
    raise NotImplementedError('Does not implemented on Windows platform')


class UserPrivileges(object):
    def __init__(self, *args, **kwargs):
        raise NotImplementedError('Does not implemented on Windows platform')


def userPrivileges(user=None, store=True, limit=False, minimalLimits=None, onlyRaiseLimits=False):
    raise NotImplementedError('Does not implemented on Windows platform')
