import os
import stat
import errno

if os.name != 'posix':
    import win32file

    def symlink(src, dst):
        win32file.CreateSymbolicLink(dst, src, 1 if os.path.isdir(src) else 0)
    os.symlink = symlink

    FILE_ATTRIBUTE_REPARSE_POINT = 0x00000400

    IO_REPARSE_TAG_MOUNT_POINT = 0xA0000003
    IO_REPARSE_TAG_HSM = 0xC0000004
    IO_REPARSE_TAG_HSM2 = 0x80000006
    IO_REPARSE_TAG_SIS = 0x80000007
    IO_REPARSE_TAG_WIM = 0x80000008
    IO_REPARSE_TAG_CSV = 0x80000009
    IO_REPARSE_TAG_DFS = 0x8000000A
    IO_REPARSE_TAG_SYMLINK = 0xA000000C
    IO_REPARSE_TAG_DFSR = 0x80000012

    def islink(path):
        findResult = win32file.FindFilesW(path)

        if len(findResult) != 1:
            return False

        findResult = findResult[0]
        # pywin32 missdesign:

        return (
            # dwFileAttributes
            (findResult[0] & FILE_ATTRIBUTE_REPARSE_POINT) and
            # dwReserved0
            (findResult[6] in (IO_REPARSE_TAG_MOUNT_POINT, IO_REPARSE_TAG_SYMLINK))
        )

    # is link present in windows but always returns False
    # (so shutil.rmtree broken in windows without this patch ( personal experience :( ))
    os.path.islink = islink

    def lstat(path):
        result = os.stat(path)
        if islink(path):
            result = result.__class__(((result[0] & ~stat.S_IFMT(result[0])) | stat.S_IFLNK,) + result[1:])
        return result

    os.lstat = lstat

    # Also we need to patch os.remove to work with symlinks to dir
    _osremove = os.remove

    def remove(path):
        try:
            # First try to call os.remove
            _osremove(path)
        except EnvironmentError as err:
            if err.errno == errno.EACCES:
                # On windows removal of symlink to directory will fail with 'Access is denied'
                # Check whether path are symlink to directory
                if os.path.isdir(path) and os.path.islink(path):
                    # Call rmdir
                    os.rmdir(path)
                else:
                    raise
            else:
                raise

    os.remove = remove
    os.unlink = remove
