from kernel.util.config import Config
from kernel.util.unittest import TestCase, main


class TestConfig(TestCase):
    def testSimpleEval(self):
        config = Config('ya.skynet.util.test.testPythonExec', """
            value: !ya!ev 10 + 20
        """)
        self.assertEqual(config.value, 30)

    def testNestedEval(self):
        config = Config('ya.skynet.util.test.testPythonExec', """
            name: test
            value: !ya!ev name + '2'
        """)
        self.assertEqual(config.value, 'test2')

    def testModuleEval(self):
        import kernel.util.sys.ncpu

        config = Config('ya.skynet.util.test.testPythonExec', """
            value: !ya!ev kernel.util.sys.ncpu.nCpu()
        """)

        self.assertEqual(config.value, kernel.util.sys.ncpu.nCpu())

if __name__ == '__main__':
    main()
