from kernel.util.unittest import TestCase, main
from kernel.util.functional import Cache

import time


k = 'x'
v = 1


class TestCache(TestCase):
    def test_not_expired(self):
        c = make_cache()
        self.assertTrue(k in c)
        self.assertEqual(v, c[k])
        self.assertEqual(v, c.get(k))
        self.assertIsNone(c.get(k * 2))

    def test_expired(self):
        c = make_cache(True)
        self.assertFalse(k in c)
        with self.assertRaises(KeyError):
            c[k]
        self.assertIsNone(c.get(k))


def make_cache(expired=False):
    cache = Cache(cachePeriod=0.000001 if expired else 1000000)
    cache[k] = v
    if expired:
        time.sleep(0.01)
    return cache


if __name__ == "__main__":
    main()
