"""
Tests for our greenlet wrapper
"""

__author__ = 'torkve'

from kernel.util.unittest import TestCase, main
from kernel.util.gevent.greenlet import spawn

from gevent.hub import Hub
from gevent import getcurrent, sleep


class TestGreenlet(TestCase):
    def testContextSwitch(self):
        ctx1 = SimpleContextSwitcher(self, 1)
        ctx2 = SimpleContextSwitcher(self, 2)
        ctx3 = SimpleContextSwitcher(self, 3)

        g1 = spawn(ctx1.check)
        g2 = spawn(ctx2.check)
        g3 = spawn(ctx3.check)

        g1.get()
        g2.get()
        g3.get()

        self.assertTrue(SimpleContextSwitcher.globalState is None)


class SimpleContextSwitcher(object):
    globalState = None

    def __init__(self, test, state):
        self.test = test
        self.state = state
        self.savedState = None

    def __enter__(self):
        greenlet = getcurrent()
        if not isinstance(greenlet, Hub):
            greenlet.registerContext(self)

        self.savedState = SimpleContextSwitcher.globalState
        SimpleContextSwitcher.globalState = self.state

    def __exit__(self, exc_type, exc, tb):
        greenlet = getcurrent()
        if not isinstance(greenlet, Hub):
            greenlet.unregisterContext(self)
        SimpleContextSwitcher.globalState = self.savedState

    def check(self):
        with self:
            for i in range(3):
                self.test.assertEqual(self.state, SimpleContextSwitcher.globalState)
                sleep(0.2)


if __name__ == '__main__':
    main()
