from kernel.util.mtitertools import imtmap
from kernel.util.unittest import TestCase, main


class TestIterTools(TestCase):
    def testIMtMap(self):
        for l in (0, 5, 200, 1000):
            a = set((i * i for i in range(l)))
            b = set(imtmap(lambda i: i * i, range(l)))
            self.assertEqual(a, b)

    def testIMtMapException(self):
        from socket import gethostbyaddr
        self.assertRaises(IOError, lambda: list(imtmap(gethostbyaddr, ["ws1-100", "ws2-200", "--askldjl313---"])))


if __name__ == "__main__":
    main()
