from random import random
from kernel.util.pickle import dumps, loads
from kernel.util.unittest import TestCase, main


class A(object):
    def __init__(self):
        self.id = random()

    def __eq__(self, other):
        return self.__class__ == other.__class__ and self.id == other.id

    def a(self):
        return self.__a

    def aa(self):
        return self.__a

    def b(self):
        pass

    def __a(self):
        pass

    def __b__(self):
        pass


class B(A):
    def a(self):
        return self.__a

    def __a(self):
        pass

    def __b__(self):
        pass


class TestPickle(TestCase):
    def testSimpleInstanceMethod(self):
        a1 = A()
        a2 = A()
        a3 = A()
        a3.id = a1.id

        b1 = B()
        b2 = B()
        b2.id = a1.id

        self.assertEqual(a1.a, loads(dumps(a1.a)))
        self.assertNotEqual(a2.a, loads(dumps(a1.a)))
        self.assertEqual(a1.a, loads(dumps(a3.a)))
        self.assertNotEqual(a1.b, loads(dumps(b1.b)))
        self.assertNotEqual(a1.b, loads(dumps(b2.b)))
        # Will fail in python >=3 (Could be implemented in python >=3.3 (Because of PEP 3155 (__qualname__)))
        self.assertEqual(A.b, loads(dumps(B.b)))
        # Also starting from python 3.3 it is possible to implement pickling of subclasses (A.C)

    def testUnderInstanceMethod(self):
        a1 = A()
        b1 = B()

        self.assertEqual(a1.__b__, loads(dumps(a1.__b__)))

        self.assertEqual(a1.a(), loads(dumps(a1.a())))
        self.assertEqual(b1.a(), loads(dumps(b1.a())))
        self.assertEqual(b1.aa(), loads(dumps(b1.aa())))
        self.assertNotEqual(b1.a(), loads(dumps(b1.aa())))


if __name__ == '__main__':
    main()
